/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.matchers;

import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class ContainingValue
extends TypeSafeMatcher<JsonNode> {
    private final Matcher<?> matcher;

    public ContainingValue(Matcher<?> matcher) {
        this.matcher = matcher;
    }

    public void describeTo(Description description) {
        description.appendText("A JSON array containing: ");
        this.matcher.describeTo(description);
    }

    public boolean matchesSafely(JsonNode node) {
        if (!node.isArray()) {
            return false;
        }
        Iterator nodeIterator = node.getElements();
        while (nodeIterator.hasNext()) {
            String value = ((JsonNode)nodeIterator.next()).getTextValue();
            if (!this.matcher.matches((Object)value)) continue;
            return true;
        }
        return false;
    }
}

