/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.matchers;

import com.github.restdriver.serverdriver.http.Header;
import com.github.restdriver.serverdriver.http.response.Response;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class HasHeaderWithValue
extends TypeSafeMatcher<Response> {
    private final String name;
    private final Matcher<String> valueMatcher;

    public HasHeaderWithValue(String name, Matcher<String> valueMatcher) {
        this.name = name;
        this.valueMatcher = valueMatcher;
    }

    protected boolean matchesSafely(Response response) {
        for (Header header : response.getHeaders()) {
            if (!StringUtils.equalsIgnoreCase((String)header.getName(), (String)this.name)) continue;
            return this.valueMatcher.matches((Object)header.getValue());
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("Response with header named '" + this.name + "' and value matching: ");
        this.valueMatcher.describeTo(description);
    }

    protected void describeMismatchSafely(Response response, Description mismatchDescription) {
        List<Header> headers = response.getHeaders();
        if (headers.isEmpty()) {
            mismatchDescription.appendText("Response has no headers");
        } else {
            mismatchDescription.appendText("Response has headers [" + StringUtils.join(response.getHeaders(), (String)",") + "]");
        }
    }
}

