/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.matchers;

import org.codehaus.jackson.JsonNode;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class HasJsonArray
extends TypeSafeMatcher<JsonNode> {
    private final String fieldName;
    private final Matcher<?> arrayMatcher;

    public HasJsonArray(String fieldName, Matcher<?> arrayMatcher) {
        this.fieldName = fieldName;
        this.arrayMatcher = arrayMatcher;
    }

    public void describeTo(Description description) {
        description.appendText("JsonNode with '" + this.fieldName + "' matching: ");
        this.arrayMatcher.describeTo(description);
    }

    public boolean matchesSafely(JsonNode jsonNode) {
        JsonNode node = jsonNode.get(this.fieldName);
        if (node == null) {
            return false;
        }
        if (node.isArray()) {
            return this.arrayMatcher.matches((Object)node);
        }
        return false;
    }
}

