/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.matchers;

import org.codehaus.jackson.JsonNode;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class HasJsonValue
extends TypeSafeMatcher<JsonNode> {
    private final String fieldName;
    private final Matcher<?> valueMatcher;

    public HasJsonValue(String fieldName, Matcher<?> valueMatcher) {
        this.fieldName = fieldName;
        this.valueMatcher = valueMatcher;
    }

    public void describeTo(Description description) {
        description.appendText("JsonNode with '" + this.fieldName + "' matching: ");
        this.valueMatcher.describeTo(description);
    }

    public boolean matchesSafely(JsonNode jsonNode) {
        JsonNode node = jsonNode.get(this.fieldName);
        if (node == null) {
            return false;
        }
        if (node.isInt()) {
            return this.valueMatcher.matches((Object)node.getIntValue());
        }
        if (node.isTextual()) {
            return this.valueMatcher.matches((Object)node.getTextValue());
        }
        return false;
    }
}

