/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver;

import com.github.restdriver.serverdriver.http.exception.RuntimeMappingException;
import com.github.restdriver.serverdriver.http.response.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class Xml {
    private static final int PARSE_ERROR_EXCERPT_LENGTH = 16;

    private Xml() {
    }

    public static Element asXml(Response response) {
        return Xml.asXml(response.getContent());
    }

    public static Element asXml(String xml) {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes("UTF-8"))).getDocumentElement();
        }
        catch (IOException e) {
            throw new RuntimeMappingException("Can't parse XML.  Bad content >> " + xml.substring(0, 16) + "...", e);
        }
        catch (SAXException e) {
            throw new RuntimeMappingException("Can't parse XML.  Bad content >> " + xml.substring(0, 16) + "...", e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeMappingException("Can't parse XML.  Bad content >> " + xml.substring(0, 16) + "...", e);
        }
    }

    public static String extractXPathValue(String expression, Element element) {
        XPathExpression compiledXPath;
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            compiledXPath = xPath.compile(expression);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Failed to compile XPath '" + expression + "'", e);
        }
        try {
            return compiledXPath.evaluate(element, XPathConstants.STRING).toString();
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Failed to evaluate XPath '" + expression + "'", e);
        }
    }
}

