/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.file;

import com.github.restdriver.serverdriver.file.RuntimeFileNotFoundException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public final class FileHelper {
    private static final String DEFAULT_ENCODING = "UTF-8";

    private FileHelper() {
    }

    public static String fromFile(String fileName, String encoding) {
        InputStream stream = FileHelper.class.getClassLoader().getResourceAsStream(fileName);
        if (stream == null) {
            throw new RuntimeFileNotFoundException(new FileNotFoundException(fileName));
        }
        try {
            return IOUtils.toString((InputStream)stream, (String)encoding);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read from file " + fileName, e);
        }
    }

    public static String fromFile(String fileName) {
        return FileHelper.fromFile(fileName, DEFAULT_ENCODING);
    }

    public static FileWithParametersBuilder fromFileWithParameters(String filename) {
        return FileHelper.fromFileWithParameters(filename, DEFAULT_ENCODING);
    }

    public static FileWithParametersBuilder fromFileWithParameters(String filename, String encoding) {
        return new FileWithParametersBuilder(FileHelper.fromFile(filename, encoding));
    }

    public static class FileWithParametersBuilder {
        private final String contents;

        public FileWithParametersBuilder(String contents) {
            this.contents = contents;
        }

        public FileWithParametersBuilder withParameter(String name, String value) {
            return new FileWithParametersBuilder(this.substitute(name, value));
        }

        public FileWithParametersBuilder withParameters(Map<String, String> parameters) {
            FileWithParametersBuilder builder = this;
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                builder = builder.withParameter(entry.getKey(), entry.getValue());
            }
            return builder;
        }

        private String substitute(String name, String value) {
            return this.contents.replace("{{" + name + "}}", value);
        }

        public String toString() {
            return this.contents;
        }
    }
}

