/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.http;

import com.github.restdriver.serverdriver.http.AnyRequestModifier;
import com.github.restdriver.serverdriver.http.ServerDriverHttpUriRequest;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;

public class ByteArrayRequestBody
implements AnyRequestModifier {
    private final byte[] content;
    private final String contentType;

    public ByteArrayRequestBody(byte[] content, String contentType) {
        this.content = content;
        this.contentType = contentType;
    }

    @Override
    public void applyTo(ServerDriverHttpUriRequest request) {
        HttpUriRequest internalRequest = request.getHttpUriRequest();
        if (!(internalRequest instanceof HttpEntityEnclosingRequest)) {
            return;
        }
        HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)internalRequest;
        entityRequest.setHeader("Content-type", this.contentType);
        ByteArrayEntity entity = new ByteArrayEntity(this.content);
        entity.setContentType(this.contentType);
        entityRequest.setEntity((HttpEntity)entity);
    }
}

