/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.http;

import com.github.restdriver.serverdriver.http.AnyRequestModifier;
import com.github.restdriver.serverdriver.http.ServerDriverHttpUriRequest;
import com.github.restdriver.serverdriver.matchers.Rfc1123DateMatcher;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public final class Header
implements AnyRequestModifier {
    private static final int HASH_CODE_PRIME = 31;
    private final String name;
    private final String value;

    public Header(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Header(String nameAndValue) {
        String[] parts = nameAndValue.split(":", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Single-argument Header must be 'name: value'");
        }
        this.name = StringUtils.trim((String)parts[0]);
        this.value = StringUtils.trim((String)parts[1]);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void applyTo(ServerDriverHttpUriRequest request) {
        request.getHttpUriRequest().addHeader(this.name, this.value);
    }

    public String toString() {
        return String.format("%s: %s", this.name, this.value);
    }

    public DateTime asDateTime() {
        return new Rfc1123DateMatcher().getDateTime(this.getValue());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.name == null ? 0 : this.name.toLowerCase().hashCode());
        result = prime * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Header)) {
            return false;
        }
        Header other = (Header)object;
        return StringUtils.equalsIgnoreCase((String)this.name, (String)other.name) && StringUtils.equals((String)this.value, (String)other.value);
    }
}

