/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.http;

import com.github.restdriver.serverdriver.http.AnyRequestModifier;
import com.github.restdriver.serverdriver.http.ServerDriverHttpUriRequest;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public final class RequestBody
implements AnyRequestModifier {
    private static final String DEFAULT_CONTENT_ENCODING = "UTF-8";
    private final String content;
    private final String contentType;

    public RequestBody(String content, String contentType) {
        this.content = content;
        this.contentType = contentType;
    }

    @Deprecated
    public String getContent() {
        return this.content;
    }

    @Deprecated
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void applyTo(ServerDriverHttpUriRequest request) {
        HttpUriRequest internalRequest = request.getHttpUriRequest();
        if (!(internalRequest instanceof HttpEntityEnclosingRequest)) {
            return;
        }
        HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)internalRequest;
        entityRequest.setHeader("Content-type", this.contentType);
        entityRequest.setEntity((HttpEntity)new StringEntity(this.content, this.createContentType(this.contentType)));
    }

    private ContentType createContentType(String contentType) {
        try {
            MimeType mimeType = new MimeType(contentType);
            String mediaType = mimeType.getBaseType();
            String charset = StringUtils.defaultString((String)mimeType.getParameter("charset"), (String)DEFAULT_CONTENT_ENCODING);
            return ContentType.create((String)mediaType, (String)charset);
        }
        catch (MimeTypeParseException e) {
            throw new IllegalArgumentException("Invalid content type: " + contentType, e);
        }
    }
}

