/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.http;

import com.github.restdriver.serverdriver.http.exception.RuntimeUriSyntaxException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;

public class Url {
    private StrBuilder url;
    private List<QueryParam> queryParams;

    public Url(String base) {
        this.url = new StrBuilder(base);
        this.queryParams = new ArrayList<QueryParam>();
    }

    public final Url withPath(String path) {
        if (!this.url.endsWith("/") && !path.startsWith("/")) {
            this.url.append("/");
        }
        if (this.url.endsWith("/") && path.startsWith("/")) {
            path = path.substring(1);
        }
        this.url.append(path);
        return this;
    }

    public final Url withParam(String key, String value) {
        this.queryParams.add(new QueryParam(key, value));
        return this;
    }

    public final String toString() {
        String path;
        String ssp;
        String[] baseParts = this.url.toString().contains("://") ? this.url.toString().split("://") : new String[]{"http", this.url.toString()};
        String scheme = baseParts[0];
        if (baseParts[1].contains("/")) {
            ssp = baseParts[1].substring(0, baseParts[1].indexOf("/"));
            path = baseParts[1].substring(baseParts[1].indexOf("/"));
        } else {
            ssp = baseParts[1];
            path = "";
        }
        String query = StringUtils.trimToNull((String)StringUtils.join(this.queryParams, (String)"&"));
        try {
            return new URI(scheme, ssp, path, query, null).toASCIIString();
        }
        catch (URISyntaxException use) {
            throw new RuntimeUriSyntaxException("Cannot create URL", use);
        }
    }

    private final class QueryParam {
        private final String key;
        private final String value;

        private QueryParam(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

