/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.matchers;

import com.github.restdriver.serverdriver.http.Header;
import com.github.restdriver.serverdriver.http.exception.RuntimeDateFormatException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class Rfc1123DateMatcher
extends TypeSafeMatcher<Header> {
    public static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";

    public DateTime getDateTime(String rawString) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        formatter.setLenient(false);
        try {
            return new DateTime((Object)formatter.parse(rawString)).toDateTime(DateTimeZone.UTC);
        }
        catch (ParseException pe) {
            throw new RuntimeDateFormatException(pe);
        }
    }

    protected boolean matchesSafely(Header dateHeader) {
        try {
            this.getDateTime(dateHeader.getValue());
            return true;
        }
        catch (RuntimeDateFormatException pe) {
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("Rfc1123-compliant date in header, like 'Mon, 09 May 2011 18:49:18 GMT'");
    }
}

