/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.restdriver.matchers.ContainingValue;
import com.github.restdriver.matchers.HasJsonArray;
import com.github.restdriver.matchers.HasJsonValue;
import com.github.restdriver.matchers.WithSize;
import com.github.restdriver.matchers.WithValueAt;
import com.github.restdriver.serverdriver.http.exception.RuntimeMappingException;
import com.github.restdriver.serverdriver.http.response.Response;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class Json {
    private static final int PARSE_ERROR_EXCERPT_LENGTH = 16;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private Json() {
    }

    public static JsonNode asJson(Response response) {
        return Json.asJson(response.getContent());
    }

    public static JsonNode asJson(String json) {
        try {
            return MAPPER.readTree(json);
        }
        catch (IOException e) {
            throw new RuntimeMappingException("Can't parse JSON.  Bad content >> " + json.substring(0, 16) + "...", e);
        }
    }

    public static TypeSafeMatcher<JsonNode> hasJsonValue(String fieldName, Matcher<?> matcher) {
        return new HasJsonValue(fieldName, matcher);
    }

    public static TypeSafeMatcher<JsonNode> hasJsonArray(String fieldName, Matcher<?> matcher) {
        return new HasJsonArray(fieldName, matcher);
    }

    public static TypeSafeMatcher<JsonNode> containingValue(Matcher<?> matcher) {
        return new ContainingValue(matcher);
    }

    public static TypeSafeMatcher<JsonNode> withValueAt(int position, Matcher<?> matcher) {
        return new WithValueAt(position, matcher);
    }

    public static TypeSafeMatcher<JsonNode> withSize(Matcher<Integer> matcher) {
        return new WithSize(matcher);
    }
}

