/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver;

import com.github.restdriver.RestDriverProperties;
import com.github.restdriver.serverdriver.http.AnyRequestModifier;
import com.github.restdriver.serverdriver.http.BasicAuth;
import com.github.restdriver.serverdriver.http.ByteArrayRequestBody;
import com.github.restdriver.serverdriver.http.Header;
import com.github.restdriver.serverdriver.http.HttpMethod;
import com.github.restdriver.serverdriver.http.NoOpRequestProxy;
import com.github.restdriver.serverdriver.http.RequestBody;
import com.github.restdriver.serverdriver.http.RequestConnectionTimeout;
import com.github.restdriver.serverdriver.http.RequestProxy;
import com.github.restdriver.serverdriver.http.RequestSocketTimeout;
import com.github.restdriver.serverdriver.http.RequestTimeout;
import com.github.restdriver.serverdriver.http.ServerDriverHttpUriRequest;
import com.github.restdriver.serverdriver.http.Url;
import com.github.restdriver.serverdriver.http.exception.RuntimeClientProtocolException;
import com.github.restdriver.serverdriver.http.exception.RuntimeConnectException;
import com.github.restdriver.serverdriver.http.exception.RuntimeUnknownHostException;
import com.github.restdriver.serverdriver.http.request.HttpDeleteWithEntity;
import com.github.restdriver.serverdriver.http.request.HttpGetWithEntity;
import com.github.restdriver.serverdriver.http.response.DefaultResponse;
import com.github.restdriver.serverdriver.http.response.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public final class RestServerDriver {
    private static final int DEFAULT_HTTP_PROXY_PORT = 80;
    public static final long DEFAULT_CONNECTION_TIMEOUT = 10000L;
    public static final long DEFAULT_SOCKET_TIMEOUT = 10000L;
    private static final String USER_AGENT = "User-Agent";
    private static final String DEFAULT_USER_AGENT = "rest-server-driver/" + RestDriverProperties.getVersion();
    private static ClientConnectionManager ccm = null;
    private static HttpParams httpParams = null;

    private RestServerDriver() {
    }

    public static Header header(String name, String value) {
        return new Header(name, value);
    }

    public static Header header(String nameAndValue) {
        return new Header(nameAndValue);
    }

    public static RequestBody body(String content, String contentType) {
        return new RequestBody(content, contentType);
    }

    public static ByteArrayRequestBody body(byte[] content, String contentType) {
        return new ByteArrayRequestBody(content, contentType);
    }

    public static ByteArrayRequestBody body(InputStream content, String contentType) {
        byte[] bytes;
        try {
            bytes = IOUtils.toByteArray((InputStream)content);
        }
        catch (IOException e) {
            throw new RuntimeException("Error converting stream to bytes", e);
        }
        return new ByteArrayRequestBody(bytes, contentType);
    }

    public static ByteArrayRequestBody body(Reader content, String contentType) {
        byte[] bytes;
        try {
            bytes = IOUtils.toByteArray((Reader)content);
        }
        catch (IOException e) {
            throw new RuntimeException("Error converting reader to bytes", e);
        }
        return new ByteArrayRequestBody(bytes, contentType);
    }

    public static BasicAuth withBasicAuth(String username, String password) {
        return new BasicAuth(username, password);
    }

    public static RequestProxy usingProxy(String proxyHost, int proxyPort) {
        return new RequestProxy(proxyHost, proxyPort);
    }

    public static NoOpRequestProxy notUsingProxy() {
        return new NoOpRequestProxy();
    }

    public static AnyRequestModifier usingSystemProxy() {
        String proxyHost = System.getProperty("http.proxyHost");
        int proxyPort = RestServerDriver.getSystemProxyPort();
        if (proxyHost.isEmpty()) {
            return new NoOpRequestProxy();
        }
        return new RequestProxy(proxyHost, proxyPort);
    }

    private static int getSystemProxyPort() {
        try {
            return Integer.parseInt(System.getProperty("http.proxyPort"));
        }
        catch (NumberFormatException nfe) {
            return 80;
        }
    }

    public static AnyRequestModifier withTimeout(int timeout, TimeUnit timeUnit) {
        return new RequestTimeout(timeUnit.toMillis(timeout), timeUnit.toMillis(timeout));
    }

    public static AnyRequestModifier withConnectionTimeout(int timeout, TimeUnit timeUnit) {
        return new RequestConnectionTimeout(timeUnit.toMillis(timeout));
    }

    public static AnyRequestModifier withSocketTimeout(int timeout, TimeUnit timeUnit) {
        return new RequestSocketTimeout(timeUnit.toMillis(timeout));
    }

    public static Url url(String base) {
        return new Url(base);
    }

    public static Response options(Object url) {
        ServerDriverHttpUriRequest request = new ServerDriverHttpUriRequest((HttpUriRequest)new HttpOptions(url.toString()));
        return RestServerDriver.doHttpRequest(request);
    }

    public static Response optionsOf(Object url) {
        return RestServerDriver.options(url);
    }

    public static Response get(Object url, AnyRequestModifier ... modifiers) {
        ServerDriverHttpUriRequest request = new ServerDriverHttpUriRequest((HttpUriRequest)new HttpGetWithEntity(url.toString()));
        RestServerDriver.applyModifiersToRequest(modifiers, request);
        return RestServerDriver.doHttpRequest(request);
    }

    public static Response getOf(Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.get(url, modifiers);
    }

    public static Response doGetOf(Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.get(url, modifiers);
    }

    public static Response getting(Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.get(url, modifiers);
    }

    public static Response post(Object url, AnyRequestModifier ... modifiers) {
        ServerDriverHttpUriRequest request = new ServerDriverHttpUriRequest((HttpUriRequest)new HttpPost(url.toString()));
        RestServerDriver.applyModifiersToRequest(modifiers, request);
        return RestServerDriver.doHttpRequest(request);
    }

    public static Response postOf(Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.post(url, modifiers);
    }

    public static Response doPostOf(Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.post(url, modifiers);
    }

    public static Response posting(Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.post(url, modifiers);
    }

    public static Response method(String method, Object url, AnyRequestModifier ... modifiers) {
        ServerDriverHttpUriRequest request = new ServerDriverHttpUriRequest((HttpUriRequest)new HttpMethod(method, url.toString()));
        RestServerDriver.applyModifiersToRequest(modifiers, request);
        return RestServerDriver.doHttpRequest(request);
    }

    public static Response methodOf(String method, Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.method(method, url, modifiers);
    }

    public static Response doMethodOf(String method, Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.method(method, url, modifiers);
    }

    public static Response methoding(String method, Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.method(method, url, modifiers);
    }

    public static Response put(Object url, AnyRequestModifier ... modifiers) {
        ServerDriverHttpUriRequest request = new ServerDriverHttpUriRequest((HttpUriRequest)new HttpPut(url.toString()));
        RestServerDriver.applyModifiersToRequest(modifiers, request);
        return RestServerDriver.doHttpRequest(request);
    }

    public static Response putOf(Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.put(url, modifiers);
    }

    public static Response doPutOf(Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.put(url, modifiers);
    }

    public static Response putting(Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.put(url, modifiers);
    }

    public static Response delete(Object url, AnyRequestModifier ... modifiers) {
        ServerDriverHttpUriRequest request = new ServerDriverHttpUriRequest((HttpUriRequest)new HttpDeleteWithEntity(url.toString()));
        RestServerDriver.applyModifiersToRequest(modifiers, request);
        return RestServerDriver.doHttpRequest(request);
    }

    public static Response deleteOf(Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.delete(url, modifiers);
    }

    public static Response doDeleteOf(Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.delete(url, modifiers);
    }

    public static Response deleting(Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.delete(url, modifiers);
    }

    public static Response head(Object url, AnyRequestModifier ... modifiers) {
        ServerDriverHttpUriRequest request = new ServerDriverHttpUriRequest((HttpUriRequest)new HttpHead(url.toString()));
        RestServerDriver.applyModifiersToRequest(modifiers, request);
        return RestServerDriver.doHttpRequest(request);
    }

    public static Response headOf(Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.head(url, modifiers);
    }

    public static Response doHeadOf(Object url, AnyRequestModifier ... modifiers) {
        return RestServerDriver.head(url, modifiers);
    }

    private static void applyModifiersToRequest(AnyRequestModifier[] modifiers, ServerDriverHttpUriRequest request) {
        if (modifiers == null) {
            return;
        }
        for (AnyRequestModifier modifier : modifiers) {
            modifier.applyTo(request);
        }
    }

    private static Response doHttpRequest(ServerDriverHttpUriRequest request) {
        HttpUriRequest httpUriRequest;
        DefaultHttpClient httpClient = new DefaultHttpClient(ccm, httpParams);
        HttpParams httpParams = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)((int)request.getConnectionTimeout()));
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)((int)request.getSocketTimeout()));
        HttpClientParams.setRedirecting((HttpParams)httpParams, (boolean)false);
        if (request.getProxyHost() != null) {
            httpParams.setParameter("http.route.default-proxy", (Object)request.getProxyHost());
        }
        if (!(httpUriRequest = request.getHttpUriRequest()).containsHeader(USER_AGENT)) {
            httpUriRequest.addHeader(USER_AGENT, DEFAULT_USER_AGENT);
        }
        try {
            long startTime = System.currentTimeMillis();
            HttpResponse response = httpClient.execute(httpUriRequest);
            long endTime = System.currentTimeMillis();
            DefaultResponse defaultResponse = new DefaultResponse(response, endTime - startTime);
            return defaultResponse;
        }
        catch (ClientProtocolException cpe) {
            throw new RuntimeClientProtocolException(cpe);
        }
        catch (UnknownHostException uhe) {
            throw new RuntimeUnknownHostException(uhe);
        }
        catch (ConnectException ce) {
            throw new RuntimeConnectException(ce);
        }
        catch (IOException e) {
            throw new RuntimeException("Error executing request", e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static void setClientConnectionManager(ClientConnectionManager ccm) {
        RestServerDriver.ccm = ccm;
    }

    public static void setHttpParams(HttpParams httpParams) {
        RestServerDriver.httpParams = httpParams;
    }
}

