/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.http;

import com.github.restdriver.serverdriver.http.AnyRequestModifier;
import com.github.restdriver.serverdriver.http.ServerDriverHttpUriRequest;
import java.net.URLConnection;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class MultipartFormBody
implements AnyRequestModifier {
    private MultipartEntityBuilder multipartContent = MultipartEntityBuilder.create();

    public MultipartFormBody addFormField(String formField, String value) {
        this.multipartContent.addPart(FormBodyPartBuilder.create((String)formField, (ContentBody)new StringBody(value, ContentType.TEXT_PLAIN)).build());
        return this;
    }

    public MultipartFormBody addFileField(String formField, String fileName, byte[] content) {
        this.multipartContent.addPart(FormBodyPartBuilder.create((String)formField, (ContentBody)new ByteArrayBody(content, ContentType.create((String)URLConnection.guessContentTypeFromName(fileName)), fileName)).build());
        return this;
    }

    @Override
    public void applyTo(ServerDriverHttpUriRequest request) {
        HttpUriRequest internalRequest = request.getHttpUriRequest();
        if (!(internalRequest instanceof HttpEntityEnclosingRequest)) {
            return;
        }
        HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)internalRequest;
        entityRequest.setEntity(this.multipartContent.build());
    }
}

