/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.http.response;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.restdriver.XmlUtil;
import com.github.restdriver.serverdriver.Json;
import com.github.restdriver.serverdriver.http.Header;
import com.github.restdriver.serverdriver.http.response.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.w3c.dom.Element;

public final class DefaultResponse
implements Response {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private final String protocolVersion;
    private final int statusCode;
    private final String statusMessage;
    private final String content;
    private final List<Header> headers;
    private final long responseTime;
    private final byte[] binaryContent;

    public DefaultResponse(HttpResponse response, long responseTime) {
        this.protocolVersion = response.getStatusLine().getProtocolVersion().toString();
        this.statusCode = response.getStatusLine().getStatusCode();
        this.statusMessage = response.getStatusLine().getReasonPhrase();
        this.binaryContent = this.binaryContentFromResponse(response);
        this.content = this.contentFromResponse(response, this.binaryContent);
        this.headers = this.headersFromResponse(response);
        this.responseTime = responseTime;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String asText() {
        return this.content;
    }

    @Override
    public List<Header> getHeaders() {
        return this.headers;
    }

    @Override
    public List<Header> getHeaders(String headerName) {
        ArrayList<Header> matchingHeaders = new ArrayList<Header>();
        for (Header header : this.headers) {
            if (!header.getName().equalsIgnoreCase(headerName)) continue;
            matchingHeaders.add(header);
        }
        return matchingHeaders;
    }

    @Override
    public Header getHeader(String headerName) {
        List<Header> matchingHeaders = this.getHeaders(headerName);
        if (matchingHeaders.isEmpty()) {
            return null;
        }
        if (matchingHeaders.size() > 1) {
            throw new IllegalStateException("Attempt to get single header '" + headerName + "' but more than one value found.");
        }
        return matchingHeaders.get(0);
    }

    @Override
    public long getResponseTime() {
        return this.responseTime;
    }

    @Override
    public JsonNode asJson() {
        return Json.asJson(this);
    }

    @Override
    public Element asXml() {
        return XmlUtil.asXml((String)this.getContent());
    }

    @Override
    public String toString() {
        return this.createSummaryString(1024);
    }

    @Override
    public String toBigString() {
        return this.createSummaryString(this.content.length());
    }

    private String createSummaryString(int truncateLength) {
        StrBuilder httpString = new StrBuilder();
        httpString.append(this.protocolVersion).append(" ").append(this.statusCode).append(" ").append(this.statusMessage);
        httpString.appendNewLine();
        httpString.appendWithSeparators(this.headers, SystemUtils.LINE_SEPARATOR);
        if (StringUtils.isNotEmpty((String)this.content)) {
            httpString.appendNewLine();
            httpString.appendNewLine();
            httpString.append(StringUtils.abbreviate((String)this.content, (int)truncateLength));
        }
        return httpString.toString();
    }

    @Override
    public String toCompactString() {
        return "status=" + this.statusCode + "|content=" + StringUtils.abbreviate((String)this.content, (int)1024) + "|headers=[" + StringUtils.join(this.headers, (String)",") + "]";
    }

    @Override
    public void tinyDump() {
        System.out.println(this.toCompactString());
    }

    @Override
    public void dump() {
        System.out.println(this.toString());
    }

    @Override
    public void bigDump() {
        System.out.println(this.toBigString());
    }

    @Override
    public byte[] asBytes() {
        return this.binaryContent;
    }

    private byte[] binaryContentFromResponse(HttpResponse response) {
        InputStream stream = null;
        try {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                byte[] byArray = null;
                return byArray;
            }
            stream = entity.getContent();
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            IOUtils.closeQuietly((InputStream)stream);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting response entity", e);
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    private String contentFromResponse(HttpResponse response, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        try {
            return this.readWithEncoding(stream, response.getEntity().getContentEncoding());
        }
        catch (IOException e) {
            throw new RuntimeException("Error converting response entity to string", e);
        }
    }

    private List<Header> headersFromResponse(HttpResponse response) {
        ArrayList<Header> parsedHeaders = new ArrayList<Header>();
        for (org.apache.http.Header currentHeader : response.getAllHeaders()) {
            Header header = new Header(currentHeader.getName(), currentHeader.getValue());
            parsedHeaders.add(header);
        }
        return parsedHeaders;
    }

    private String readWithEncoding(InputStream stream, org.apache.http.Header contentEncoding) throws IOException {
        if (contentEncoding == null) {
            return IOUtils.toString((InputStream)stream, (String)DEFAULT_ENCODING);
        }
        return IOUtils.toString((InputStream)stream, (String)contentEncoding.getValue());
    }
}

