/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.matchers;

import com.github.restdriver.serverdriver.http.Header;
import com.github.restdriver.serverdriver.http.response.Response;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public final class HasHeader
extends TypeSafeMatcher<Response> {
    private final String name;

    public HasHeader(String name) {
        this.name = name;
    }

    protected boolean matchesSafely(Response response) {
        for (Header header : response.getHeaders()) {
            if (!StringUtils.equalsIgnoreCase((String)header.getName(), (String)this.name)) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("Response with header named '" + this.name + "'");
    }

    protected void describeMismatchSafely(Response response, Description mismatchDescription) {
        List<Header> headers = response.getHeaders();
        if (headers.isEmpty()) {
            mismatchDescription.appendText("Response has no headers");
        } else {
            mismatchDescription.appendText("Response has headers [" + StringUtils.join(response.getHeaders(), (String)", ") + "]");
        }
    }
}

