/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.polling;

import com.github.restdriver.serverdriver.http.exception.RuntimeInterruptedException;
import com.github.restdriver.serverdriver.polling.TimeDuration;
import java.util.concurrent.TimeUnit;

public abstract class Poller {
    private static final int DEFAULT_ATTEMPTS = 10;
    private static final TimeDuration DEFAULT_POLL = new TimeDuration(1L, TimeUnit.SECONDS);
    private boolean loud;

    public Poller() {
        this.doPolling(10, DEFAULT_POLL);
    }

    public Poller(int times) {
        this.doPolling(times, DEFAULT_POLL);
    }

    public Poller(int times, TimeDuration pollPeriod) {
        this.doPolling(times, pollPeriod);
    }

    private void doPolling(int times, TimeDuration pollPeriod) {
        for (int remainingAttempts = times - 1; remainingAttempts >= 0; --remainingAttempts) {
            if (remainingAttempts == 0) {
                this.poll();
                continue;
            }
            try {
                this.poll();
                return;
            }
            catch (AssertionError intermediateError) {
                if (this.loud) {
                    System.out.println("remainingAttempts=" + remainingAttempts + ", caught AssertionError: " + ((Throwable)((Object)intermediateError)).getMessage());
                }
                this.sleepSoundly(pollPeriod);
            }
        }
    }

    private void sleepSoundly(TimeDuration pollPeriod) {
        try {
            pollPeriod.getTimeUnit().sleep(pollPeriod.getDuration());
        }
        catch (InterruptedException ie) {
            throw new RuntimeInterruptedException("interrupted!", ie);
        }
    }

    protected final void loudly() {
        this.loud = true;
    }

    public abstract void poll();

    public static int times(int count) {
        return count;
    }

    public static TimeDuration every(long duration, TimeUnit unit) {
        return new TimeDuration(duration, unit);
    }
}

