/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.reactive.cdi.servlet;

import com.github.rmannibucau.reactive.cdi.scope.internal.ReactiveContext;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RootReactiveContextFilter
implements Filter {
    @Inject
    private ReactiveContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        final ReactiveContext.Ctx rootCtx = this.context.start();
        request.setAttribute(ReactiveContext.Ctx.class.getName(), (Object)rootCtx);
        try {
            chain.doFilter((ServletRequest)new HttpServletRequestWrapper((HttpServletRequest)HttpServletRequest.class.cast(request)){

                public AsyncContext startAsync() throws IllegalStateException {
                    return RootReactiveContextFilter.this.cleanOnEnd(rootCtx, super.startAsync());
                }

                public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
                    return RootReactiveContextFilter.this.cleanOnEnd(rootCtx, super.startAsync(servletRequest, servletResponse));
                }
            }, response);
        }
        finally {
            if (!request.isAsyncStarted()) {
                this.context.finish(rootCtx);
            }
            this.context.reset(rootCtx);
        }
    }

    private AsyncContext cleanOnEnd(ReactiveContext.Ctx rootCtx, AsyncContext ctx) {
        ctx.addListener((AsyncListener)new ReactiveAsyncListener(this.context, rootCtx));
        return new ReactiveAsyncContext(ctx, rootCtx);
    }

    private static class ReactiveAsyncContext
    implements AsyncContext {
        private final AsyncContext delegate;
        private final ReactiveContext.Ctx current;

        private ReactiveAsyncContext(AsyncContext ctx, ReactiveContext.Ctx current) {
            this.delegate = ctx;
            this.current = current;
        }

        public void start(Runnable run) {
            this.delegate.start(this.current.wrap(run));
        }

        public ServletRequest getRequest() {
            return this.delegate.getRequest();
        }

        public ServletResponse getResponse() {
            return this.delegate.getResponse();
        }

        public boolean hasOriginalRequestAndResponse() {
            return this.delegate.hasOriginalRequestAndResponse();
        }

        public void dispatch() {
            this.delegate.dispatch();
        }

        public void dispatch(String path) {
            this.delegate.dispatch(path);
        }

        public void dispatch(ServletContext context, String path) {
            this.delegate.dispatch(context, path);
        }

        public void complete() {
            this.delegate.complete();
        }

        public void addListener(AsyncListener listener) {
            this.delegate.addListener(listener);
        }

        public void addListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
            this.delegate.addListener(listener, request, response);
        }

        public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
            return (T)this.delegate.createListener(clazz);
        }

        public void setTimeout(long timeout) {
            this.delegate.setTimeout(timeout);
        }

        public long getTimeout() {
            return this.delegate.getTimeout();
        }
    }

    private static class ReactiveAsyncListener
    implements AsyncListener {
        private final ReactiveContext scope;
        private final ReactiveContext.Ctx root;

        private ReactiveAsyncListener(ReactiveContext context, ReactiveContext.Ctx rootCtx) {
            this.scope = context;
            this.root = rootCtx;
        }

        private void onEnd() {
            this.scope.finish(this.root);
        }

        public void onComplete(AsyncEvent event) {
            this.onEnd();
        }

        public void onTimeout(AsyncEvent event) {
            this.onEnd();
        }

        public void onError(AsyncEvent event) {
            this.onEnd();
        }

        public void onStartAsync(AsyncEvent event) {
            event.getAsyncContext().addListener((AsyncListener)this);
        }
    }
}

