/*
 * Decompiled with CFR 0.152.
 */
package com.jspringbot.selenium.extension;

import com.google.common.io.Files;
import com.saucelabs.common.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.jspringbot.keyword.selenium.OsCheck;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class DesiredCapabilitiesBean
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = Logger.getLogger(DesiredCapabilitiesBean.class);
    private DesiredCapabilities capabilities;
    private Proxy proxy;
    private File baseDir;
    private Map<String, Object> chromeOptions = new HashMap<String, Object>();
    private Map<String, Object> mobileEmulation;
    private LoggingPreferences logPrefs;
    private String chromeDriverVersion;
    private String ieDriverVersion;
    private boolean archAutodetect = false;
    private String archValue = "32";
    private File tempDir;
    private File chromeDriverFile;

    public DesiredCapabilitiesBean(DesiredCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public void setFirefoxProfile(FirefoxProfile profile) {
        this.capabilities.setCapability("firefox_profile", (Object)profile);
    }

    public void setChromeDriverVersion(String chromeDriverVersion) {
        this.chromeDriverVersion = chromeDriverVersion;
    }

    public void setIeDriverVersion(String ieDriverVersion) {
        this.ieDriverVersion = ieDriverVersion;
    }

    public void setBaseDir(String baseStrDir) {
        if (StringUtils.isNotBlank((String)baseStrDir) && !StringUtils.equalsIgnoreCase((String)baseStrDir, (String)"none")) {
            this.baseDir = new File(baseStrDir);
            if (!this.baseDir.isDirectory()) {
                this.baseDir.mkdirs();
            }
        }
    }

    public void setArchAutodetect(boolean archAutodetect) {
        this.archAutodetect = archAutodetect;
    }

    public void setArchValue(String archValue) {
        this.archValue = archValue;
    }

    public void setChromeDrivers(Map<OsCheck.OSType, Resource> chromeDrivers) throws IOException {
        OsCheck.OSType osType = OsCheck.getOperatingSystemType();
        Resource chromeDriver = chromeDrivers.get(osType);
        if (chromeDriver == null) {
            throw new IllegalArgumentException("Unsupported OS " + osType.name());
        }
        File driverDir = this.createDriverDir();
        File downloadedFile = new File(driverDir, chromeDriver.getFilename());
        if (!downloadedFile.isFile()) {
            LOGGER.info((Object)("Chrome driver version: " + this.chromeDriverVersion));
            System.out.println("Downloading driver: " + chromeDriver.getURL());
            IOUtils.copy((InputStream)chromeDriver.getInputStream(), (OutputStream)new FileOutputStream(downloadedFile));
        }
        LOGGER.info((Object)("Chrome driver file: " + downloadedFile.getAbsolutePath()));
        System.out.println(downloadedFile.getAbsolutePath());
        this.tempDir = Files.createTempDir();
        this.chromeDriverFile = DesiredCapabilitiesBean.unzip(new FileInputStream(downloadedFile), this.tempDir);
        this.chromeDriverFile.setExecutable(true);
        System.setProperty("webdriver.chrome.driver", this.chromeDriverFile.getAbsolutePath());
        System.out.println(this.chromeDriverFile.getAbsolutePath());
    }

    public void destroy() throws Exception {
        if (this.chromeDriverFile != null && this.chromeDriverFile.isFile() && this.chromeDriverFile.isFile()) {
            this.chromeDriverFile.delete();
        }
        if (this.tempDir != null && this.tempDir.isDirectory()) {
            this.tempDir.delete();
        }
    }

    private File createDriverDir() {
        File driverDir;
        if (this.baseDir != null) {
            driverDir = this.baseDir;
        } else {
            String userHome = System.getProperty("user.home");
            driverDir = new File(userHome, "jspringbot");
            if (!driverDir.isDirectory()) {
                driverDir.mkdirs();
            }
        }
        return driverDir;
    }

    public void setIeDriver(Map<String, Resource> resourceMap) throws IOException {
        Resource resource;
        File downloadedFile;
        File driverDir = this.createDriverDir();
        String arch = this.archValue;
        if (this.archAutodetect) {
            arch = System.getProperty("sun.arch.data.model");
        }
        if (!(downloadedFile = new File(driverDir, (resource = resourceMap.get(arch)).getFilename())).isFile()) {
            LOGGER.info((Object)("Internet driver version" + this.ieDriverVersion));
            LOGGER.info((Object)("Downloading driver: " + resource.getURL()));
            IOUtils.copy((InputStream)resource.getInputStream(), (OutputStream)new FileOutputStream(downloadedFile));
        }
        LOGGER.info((Object)("IE driver file: " + downloadedFile.getAbsolutePath()));
        File driver = DesiredCapabilitiesBean.unzip(new FileInputStream(downloadedFile), driverDir);
        driver.setExecutable(true);
        System.setProperty("webdriver.ie.driver", driver.getAbsolutePath());
    }

    public void setChromeOptions(Map<String, Object> chromeOptions) {
        this.chromeOptions = chromeOptions;
    }

    public void setChromeDeviceMetrics(String deviceMetrics) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (StringUtils.isNotBlank((String)deviceMetrics) && !StringUtils.equalsIgnoreCase((String)deviceMetrics, (String)"none")) {
            String[] metrics;
            if (this.mobileEmulation == null) {
                this.mobileEmulation = new HashMap<String, Object>();
            }
            if ((metrics = StringUtils.split((String)deviceMetrics, (String)"x")).length < 2) {
                throw new IllegalArgumentException("Expected <width>x<height>x<pixel_ratio> but was " + deviceMetrics);
            }
            String[] NAMES = new String[]{"width", "height", "pixelRatio"};
            Class[] CLASSES = new Class[]{Integer.class, Integer.class, Double.class};
            HashMap<String, Object> deviceMetricsMap = new HashMap<String, Object>();
            for (int i = 0; i < metrics.length && i < NAMES.length; ++i) {
                deviceMetricsMap.put(NAMES[i], this.classValueOf(CLASSES[i], metrics[i]));
            }
            this.mobileEmulation.put("deviceMetrics", deviceMetricsMap);
        }
    }

    private Object classValueOf(Class clazz, String item) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = clazz.getDeclaredMethod("valueOf", String.class);
        return method.invoke((Object)clazz, item);
    }

    public void setChromeDeviceEmulation(String deviceEmulation) {
        if (StringUtils.isNotBlank((String)deviceEmulation) && !StringUtils.equalsIgnoreCase((String)deviceEmulation, (String)"none")) {
            if (this.mobileEmulation == null) {
                this.mobileEmulation = new HashMap<String, Object>();
            }
            this.mobileEmulation.put("deviceName", deviceEmulation);
        }
    }

    public void setChromeDeviceUserAgent(String userAgent) {
        if (StringUtils.isNotBlank((String)userAgent) && !StringUtils.equalsIgnoreCase((String)userAgent, (String)"none")) {
            if (this.mobileEmulation == null) {
                this.mobileEmulation = new HashMap<String, Object>();
            }
            this.mobileEmulation.put("userAgent", userAgent);
        }
    }

    public void setChromeBrowserLog(String level) {
        if (StringUtils.isNotBlank((String)level) && !StringUtils.equalsIgnoreCase((String)level, (String)"none")) {
            if (this.logPrefs == null) {
                this.logPrefs = new LoggingPreferences();
            }
            this.logPrefs.enable("browser", Level.parse(level));
        }
    }

    public void setChromePerformanceLog(String level) {
        if (StringUtils.isNotBlank((String)level) && !StringUtils.equalsIgnoreCase((String)level, (String)"none")) {
            if (this.logPrefs == null) {
                this.logPrefs = new LoggingPreferences();
            }
            this.logPrefs.enable("performance", Level.parse(level));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File unzip(InputStream in, File dir) throws IOException {
        ZipInputStream zin = null;
        byte[] buf = new byte[2048];
        File entryFile = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream(in);
            while ((entry = zin.getNextEntry()) != null) {
                FileOutputStream out = null;
                entryFile = new File(dir, entry.getName());
                try {
                    int len;
                    out = new FileOutputStream(entryFile);
                    while ((len = zin.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                    return entryFile;
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((InputStream)zin);
        }
    }

    public void setChromeLogFile(String logFile) {
        if (StringUtils.isNotBlank((String)logFile) && !StringUtils.equalsIgnoreCase((String)logFile, (String)"none")) {
            File file = new File(logFile);
            File dir = file.getParentFile();
            if (dir != null && !dir.isDirectory()) {
                dir.mkdirs();
            }
            System.setProperty("webdriver.chrome.logfile", file.getAbsolutePath());
        }
    }

    public void setBrowserName(String browserName) {
        if (!StringUtils.equalsIgnoreCase((String)browserName, (String)"none")) {
            this.capabilities.setCapability("browserName", browserName);
        }
    }

    public void setVersion(String version) {
        if (!StringUtils.equalsIgnoreCase((String)version, (String)"none")) {
            this.capabilities.setCapability("version", version);
        }
    }

    public void setPlatform(String platform) {
        if (!StringUtils.equalsIgnoreCase((String)platform, (String)"none")) {
            this.capabilities.setCapability("platform", platform);
        }
    }

    public void setPlatformVersion(String platformVersion) {
        if (!StringUtils.equalsIgnoreCase((String)platformVersion, (String)"none")) {
            this.capabilities.setCapability("platformVersion", platformVersion);
        }
    }

    public void setDeviceName(String deviceName) {
        if (!StringUtils.equalsIgnoreCase((String)deviceName, (String)"none")) {
            this.capabilities.setCapability("deviceName", deviceName);
        }
    }

    public void setDeviceOrientation(String deviceOrientation) {
        if (!StringUtils.equalsIgnoreCase((String)deviceOrientation, (String)"none")) {
            if (StringUtils.equals((String)String.valueOf(this.capabilities.getCapability("deviceType")), (String)"phone")) {
                this.capabilities.setCapability("deviceOrientation", deviceOrientation);
            } else {
                this.capabilities.setCapability("device-orientation", deviceOrientation);
            }
        }
    }

    public void setDeviceType(String deviceType) {
        if (!StringUtils.equalsIgnoreCase((String)deviceType, (String)"none")) {
            this.capabilities.setCapability("deviceType", deviceType);
        }
    }

    public void setAppiumVersion(String appiumVersion) {
        if (!StringUtils.equalsIgnoreCase((String)appiumVersion, (String)"none")) {
            this.capabilities.setCapability("appiumVersion", appiumVersion);
        }
    }

    public void setName(String name) {
        if (!StringUtils.equalsIgnoreCase((String)name, (String)"none")) {
            this.capabilities.setCapability("name", name);
        }
    }

    public void setBuild(String build) {
        if (!StringUtils.equalsIgnoreCase((String)build, (String)"none")) {
            this.capabilities.setCapability("build", build);
        } else {
            HashMap map = new HashMap();
            Utils.addBuildNumberToUpdate(map);
            if (map.containsKey("build")) {
                this.capabilities.setCapability("build", map.get("build"));
            }
        }
    }

    public void setTunnelId(String tunnelId) {
        if (!StringUtils.equalsIgnoreCase((String)tunnelId, (String)"none")) {
            this.capabilities.setCapability("tunnel-identifier", tunnelId);
        }
    }

    public void setMaxDuration(String maxDuration) {
        if (!StringUtils.equalsIgnoreCase((String)maxDuration, (String)"none")) {
            this.capabilities.setCapability("maxDuration", (Object)Integer.parseInt(maxDuration));
        }
    }

    public void setProxy(String proxyHost) {
        if (!StringUtils.equalsIgnoreCase((String)proxyHost, (String)"none")) {
            this.proxy = new Proxy();
            this.proxy.setFtpProxy(proxyHost).setHttpProxy(proxyHost).setSslProxy(proxyHost);
            this.capabilities.setCapability("proxy", (Object)this.proxy);
        }
    }

    public void setSslProxy(String proxyHost) {
        if (!StringUtils.equalsIgnoreCase((String)proxyHost, (String)"none")) {
            this.proxy = new Proxy();
            this.proxy.setSslProxy(proxyHost);
            this.capabilities.setCapability("proxy", (Object)this.proxy);
        }
    }

    public void setFtpProxy(String proxyHost) {
        if (!StringUtils.equalsIgnoreCase((String)proxyHost, (String)"none")) {
            this.proxy = new Proxy();
            this.proxy.setFtpProxy(proxyHost);
            this.capabilities.setCapability("proxy", (Object)this.proxy);
        }
    }

    public void setHttpProxy(String proxyHost) {
        if (!StringUtils.equalsIgnoreCase((String)proxyHost, (String)"none")) {
            this.proxy = new Proxy();
            this.proxy.setHttpProxy(proxyHost);
            this.capabilities.setCapability("proxy", (Object)this.proxy);
        }
    }

    public void setCapabilities(String properties) throws JSONException {
        if (!StringUtils.equalsIgnoreCase((String)properties, (String)"none")) {
            JSONObject obj = new JSONObject(properties);
            Iterator itr = obj.keys();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                this.capabilities.setCapability(key, obj.getString(key));
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (MapUtils.isNotEmpty(this.mobileEmulation)) {
            this.chromeOptions.put("mobileEmulation", this.mobileEmulation);
        }
        if (MapUtils.isNotEmpty(this.chromeOptions)) {
            this.capabilities.setCapability("chromeOptions", this.chromeOptions);
        }
        if (this.logPrefs != null) {
            this.capabilities.setCapability("loggingPrefs", (Object)this.logPrefs);
        }
    }
}

