/*
 * Decompiled with CFR 0.152.
 */
package com.jspringbot.selenium.extension;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jspringbot.keyword.selenium.OsCheck;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class FirefoxOptionsBean
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = Logger.getLogger(FirefoxOptionsBean.class);
    private FirefoxOptions options;
    private File baseDir;
    private String geckoDriverVersion;
    private File tempDir;
    private File geckoDriverFile;

    public void destroy() throws Exception {
        if (this.geckoDriverFile != null && this.geckoDriverFile.isFile() && this.geckoDriverFile.isFile()) {
            this.geckoDriverFile.delete();
        }
        if (this.tempDir != null && this.tempDir.isDirectory()) {
            this.tempDir.delete();
        }
    }

    public void afterPropertiesSet() throws Exception {
    }

    public FirefoxOptionsBean(FirefoxOptions options) {
        this.options = options;
    }

    public void setFirefoxProfile(FirefoxProfile profile) {
        this.options.setProfile(profile);
    }

    public void setIsHeadless(boolean isHeadless) {
        this.options.setHeadless(isHeadless);
    }

    public void setGeckoDriverVersion(String geckoDriverVersion) {
        this.geckoDriverVersion = geckoDriverVersion;
    }

    private File createDriverDir() {
        File driverDir;
        if (this.baseDir != null) {
            driverDir = this.baseDir;
        } else {
            String userHome = System.getProperty("user.home");
            driverDir = new File(userHome, "jspringbot");
            if (!driverDir.isDirectory()) {
                driverDir.mkdirs();
                LOGGER.info((Object)("Created Driver Directory: " + driverDir.getAbsolutePath()));
            }
        }
        return driverDir;
    }

    public void setBaseDir(String baseStrDir) {
        if (StringUtils.isNotBlank((String)baseStrDir) && !StringUtils.equalsIgnoreCase((String)baseStrDir, (String)"none")) {
            this.baseDir = new File(baseStrDir);
            if (!this.baseDir.isDirectory()) {
                this.baseDir.mkdirs();
                LOGGER.info((Object)("Base Directory: " + this.baseDir.getAbsolutePath()));
            }
        }
    }

    public void setGeckoDrivers(Map<OsCheck.OSType, Resource> geckoDrivers) throws IOException {
        LOGGER.info((Object)"Setting Gecko Driver");
        OsCheck.OSType osType = OsCheck.getOperatingSystemType();
        Resource geckoDriver = geckoDrivers.get(osType);
        if (geckoDriver == null) {
            LOGGER.info((Object)"Unsupported OS");
            throw new IllegalArgumentException("Unsupported OS " + osType.name());
        }
        File driverDir = this.createDriverDir();
        File downloadedFile = new File(driverDir, geckoDriver.getFilename());
        if (!downloadedFile.isFile()) {
            LOGGER.info((Object)("Download Gecko driver version: " + this.geckoDriverVersion));
            LOGGER.info((Object)("Downloading driver: " + geckoDriver.getURL()));
            IOUtils.copy((InputStream)geckoDriver.getInputStream(), (OutputStream)new FileOutputStream(downloadedFile));
        }
        LOGGER.info((Object)("Gecko driver file: " + downloadedFile.getAbsolutePath()));
        System.out.println("Gecko Raw File: " + downloadedFile.getAbsolutePath());
        this.tempDir = Files.createTempDir();
        System.out.println("Temp Folder: " + this.tempDir);
        File archive = new File(downloadedFile.getAbsolutePath());
        File destination = new File(this.tempDir + "/");
        this.geckoDriverFile = new File(destination.getAbsolutePath() + "/geckodriver");
        System.out.println(this.geckoDriverFile.getAbsolutePath());
        Archiver archiver = ArchiverFactory.createArchiver((String)"tar", (String)"gz");
        archiver.extract(archive, destination);
        System.setProperty("webdriver.gecko.driver", this.geckoDriverFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File unzip(InputStream in, File dir) throws IOException {
        ZipInputStream zin = null;
        byte[] buf = new byte[2048];
        File entryFile = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream(in);
            while ((entry = zin.getNextEntry()) != null) {
                FileOutputStream out = null;
                entryFile = new File(dir, entry.getName());
                try {
                    int len;
                    out = new FileOutputStream(entryFile);
                    while ((len = zin.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                    return entryFile;
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((InputStream)zin);
        }
    }
}

