/*
 * Decompiled with CFR 0.152.
 */
package com.jspringbot.selenium.extension;

import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jspringbot.keyword.selenium.ElementFinder;
import org.jspringbot.syntax.HighlightRobotLogger;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class SeleniumExtensionHelper {
    public static final HighlightRobotLogger LOG = HighlightRobotLogger.getLogger(SeleniumExtensionHelper.class);
    protected WebDriver driver;
    protected ElementFinder finder;
    protected JavascriptExecutor executor;

    public SeleniumExtensionHelper(WebDriver driver) {
        this.driver = driver;
        this.executor = (JavascriptExecutor)driver;
        this.finder = new ElementFinder(driver);
    }

    public void closeSession() {
        this.driver.quit();
    }

    public void highlightElement(String locator) {
        LOG.keywordAppender().appendLocator(locator, new Object[0]);
        WebElement element = this.finder.find(locator);
        JavascriptExecutor js = (JavascriptExecutor)this.driver;
        js.executeScript("arguments[0].setAttribute('style', 'background: yellow; border: 2px solid red;');", new Object[]{element});
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            LOG.keywordAppender().appendArgument("Message", (Object)e.getMessage());
        }
        js.executeScript("arguments[0].setAttribute('style','border: solid 2px white');", new Object[]{element});
    }

    public void setImplicitWaitTime(long time) {
        this.driver.manage().timeouts().implicitlyWait(time, TimeUnit.SECONDS);
    }

    public void switchToActiveWindow() {
        this.driver.switchTo().activeElement();
    }

    public List<String> getListLabels(String locator) {
        LOG.keywordAppender().appendLocator(locator, new Object[0]);
        ArrayList<String> values = new ArrayList<String>();
        WebElement selectEl = this.finder.find(locator);
        Select select = new Select(selectEl);
        List options = select.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            WebElement option = (WebElement)options.get(i);
            LOG.keywordAppender().appendArgument(String.format("value=%s", option.getAttribute("value")), (Object)option.getText());
            values.add(option.getText());
        }
        LOG.keywordAppender().appendLocator("Values:", new Object[]{values});
        return values;
    }

    public List<String> getLElementsTextByXpath(String locator) {
        LOG.keywordAppender().appendLocator(locator, new Object[0]);
        ArrayList<String> values = new ArrayList<String>();
        List elements = this.driver.findElements(By.xpath((String)locator));
        if (elements.isEmpty()) {
            return null;
        }
        for (WebElement element : elements) {
            String value = element.getText();
            LOG.keywordAppender().appendArgument("value= ", (Object)value);
            values.add(value);
        }
        LOG.keywordAppender().appendLocator("Values:", new Object[]{values});
        return values;
    }

    public String getSelectSize(String locator) {
        LOG.keywordAppender().appendLocator(locator, new Object[0]);
        WebElement selectEl = this.finder.find(locator);
        Select select = new Select(selectEl);
        List options = select.getOptions();
        LOG.keywordAppender().appendLocator("Size", new Object[]{options.size()});
        return String.valueOf(options.size());
    }

    public List<String> getElementAttributesByXpath(String locator, String attribute) {
        LOG.keywordAppender().appendLocator(locator, new Object[0]);
        ArrayList<String> values = new ArrayList<String>();
        List elements = this.driver.findElements(By.xpath((String)locator));
        if (elements.isEmpty()) {
            return null;
        }
        for (WebElement element : elements) {
            String value = element.getAttribute(attribute);
            LOG.keywordAppender().appendArgument("value= ", (Object)value);
            values.add(value);
        }
        LOG.keywordAppender().appendLocator("Values:", new Object[]{values});
        return values;
    }

    public boolean isSelectListContainsValue(String locator, String value) {
        LOG.keywordAppender().appendLocator(locator, new Object[0]);
        WebElement selectEl = this.finder.find(locator);
        Select select = new Select(selectEl);
        List options = select.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            WebElement option = (WebElement)options.get(i);
            LOG.keywordAppender().appendArgument(String.format("value=%s", option.getAttribute("value")), (Object)option.getText());
            if (!option.getAttribute("value").equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean isElementDisplayed(String locator) {
        LOG.keywordAppender().appendLocator(locator, new Object[0]);
        boolean isDisplayed = this.finder.find(locator).isDisplayed();
        LOG.keywordAppender().appendArgument("Displayed", (Object)isDisplayed);
        return isDisplayed;
    }

    public boolean isSelectListContainsLabel(String locator, String value) {
        LOG.keywordAppender().appendLocator(locator, new Object[0]);
        WebElement selectEl = this.finder.find(locator);
        Select select = new Select(selectEl);
        List options = select.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            WebElement option = (WebElement)options.get(i);
            LOG.keywordAppender().appendArgument(String.format("value=%s", option.getAttribute("value")), (Object)option.getText());
            if (!option.getText().equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean isStringContains(String toCompare, String value) {
        String str1 = String.valueOf(toCompare);
        String str2 = String.valueOf(value);
        LOG.keywordAppender().append(String.format("Compare: %s and %s", str1, str2), new Object[0]);
        return str1.contains(str2);
    }

    public int getElementWidth(String locator) {
        LOG.keywordAppender().appendLocator(locator, new Object[0]);
        WebElement element = this.finder.find(locator);
        LOG.keywordAppender().appendArgument("Width", (Object)element.getSize().getWidth());
        return element.getSize().getWidth();
    }

    public int getElementHeight(String locator) {
        LOG.keywordAppender().appendLocator(locator, new Object[0]);
        WebElement element = this.finder.find(locator);
        LOG.keywordAppender().appendArgument("Height", (Object)element.getSize().getHeight());
        return element.getSize().getHeight();
    }

    private static void setClipboardData(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    public void upload(String fileLocation) {
        SeleniumExtensionHelper.setClipboardData(fileLocation);
        try {
            Robot robot = new Robot();
            Capabilities cap = ((RemoteWebDriver)this.driver).getCapabilities();
            String platform = cap.getCapability("platform").toString();
            String browserName = cap.getBrowserName();
            LOG.info("Browser: " + browserName, new Object[0]);
            Thread.sleep(2000L);
            switch (platform.toLowerCase()) {
                case "mac": {
                    LOG.info("OS: " + platform, new Object[0]);
                    if (browserName.equalsIgnoreCase("chrome")) {
                        robot.keyPress(157);
                        robot.keyPress(9);
                        robot.keyRelease(157);
                        robot.keyRelease(9);
                    }
                    robot.delay(2000);
                    robot.keyPress(157);
                    robot.keyPress(16);
                    robot.keyPress(71);
                    robot.keyRelease(157);
                    robot.keyRelease(16);
                    robot.keyRelease(71);
                    robot.keyPress(157);
                    robot.keyPress(86);
                    robot.keyRelease(157);
                    robot.keyRelease(86);
                    robot.keyPress(10);
                    robot.keyRelease(10);
                    robot.delay(2000);
                    robot.keyPress(10);
                    robot.keyRelease(10);
                    break;
                }
                case "win": {
                    LOG.info("OS: " + platform, new Object[0]);
                    robot.keyPress(17);
                    robot.keyPress(86);
                    robot.keyRelease(86);
                    robot.keyRelease(17);
                    robot.keyPress(10);
                    robot.keyRelease(10);
                    break;
                }
                case "linux": {
                    LOG.info("OS: " + platform, new Object[0]);
                    robot.keyPress(157);
                    robot.delay(500);
                    robot.keyPress(86);
                    robot.keyRelease(86);
                    robot.keyRelease(157);
                    robot.keyPress(10);
                    robot.keyRelease(10);
                    break;
                }
                default: {
                    if (browserName.equalsIgnoreCase("chrome")) {
                        robot.keyPress(157);
                        robot.keyPress(9);
                        robot.keyRelease(157);
                        robot.keyRelease(9);
                    }
                    robot.delay(2000);
                    robot.keyPress(157);
                    robot.keyPress(16);
                    robot.keyPress(71);
                    robot.keyRelease(157);
                    robot.keyRelease(16);
                    robot.keyRelease(71);
                    robot.keyPress(157);
                    robot.keyPress(86);
                    robot.keyRelease(157);
                    robot.keyRelease(86);
                    robot.keyPress(10);
                    robot.keyRelease(10);
                    robot.delay(2000);
                    robot.keyPress(10);
                    robot.keyRelease(10);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.keywordAppender().appendArgument("Message", (Object)e.getMessage());
        }
    }

    public void fileUploadByJS(String locator, String fileLocation) {
        File filePath = new File(fileLocation);
        LOG.keywordAppender().appendLocator(locator, new Object[0]);
        WebElement element = this.finder.find(locator);
        String JS_DROP_FILE = "var target = arguments[0],    offsetX = arguments[1],    offsetY = arguments[2],    document = target.ownerDocument || document,    window = document.defaultView || window;var input = document.createElement('INPUT');input.type = 'file';input.style.display = 'none';input.onchange = function () {  var rect = target.getBoundingClientRect(),      x = rect.left + (offsetX || (rect.width >> 1)),      y = rect.top + (offsetY || (rect.height >> 1)),      dataTransfer = { files: this.files };  ['dragenter', 'dragover', 'drop'].forEach(function (name) {    var evt = document.createEvent('MouseEvent');    evt.initMouseEvent(name, !0, !0, window, 0, 0, 0, x, y, !1, !1, !1, !1, 0, null);    evt.dataTransfer = dataTransfer;    target.dispatchEvent(evt);  });  setTimeout(function () { document.body.removeChild(input); }, 25);};document.body.appendChild(input);return input;";
        WebElement input = (WebElement)this.executor.executeScript(JS_DROP_FILE, new Object[]{element, 0, 0});
        input.sendKeys(new CharSequence[]{filePath.getAbsoluteFile().toString()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitElementToBePresent(String locator, int timeOut) {
        LOG.keywordAppender().appendLocator(locator, new Object[0]);
        boolean isPresent = false;
        try {
            new WebDriverWait(this.driver, (long)timeOut).until((Function)ExpectedConditions.presenceOfElementLocated((By)this.parseLocatorBy(locator)));
            isPresent = true;
        }
        catch (Exception e) {
            try {
                isPresent = false;
            }
            catch (Throwable throwable) {
                LOG.keywordAppender().append(String.format("%s", isPresent), new Object[0]);
                throw throwable;
            }
            LOG.keywordAppender().append(String.format("%s", isPresent), new Object[0]);
        }
        LOG.keywordAppender().append(String.format("%s", isPresent), new Object[0]);
        return isPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitElementToBeVisible(String locator, int timeOut) {
        LOG.keywordAppender().appendLocator(locator, new Object[0]);
        boolean isVisible = false;
        try {
            new WebDriverWait(this.driver, (long)timeOut).until((Function)ExpectedConditions.visibilityOfElementLocated((By)this.parseLocatorBy(locator)));
            isVisible = true;
        }
        catch (Exception e) {
            try {
                isVisible = false;
            }
            catch (Throwable throwable) {
                LOG.keywordAppender().append(String.format("%s", isVisible), new Object[0]);
                throw throwable;
            }
            LOG.keywordAppender().append(String.format("%s", isVisible), new Object[0]);
        }
        LOG.keywordAppender().append(String.format("%s", isVisible), new Object[0]);
        return isVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitElementToBeClickable(String locator, int timeOut) {
        LOG.keywordAppender().appendLocator(locator, new Object[0]);
        boolean isClickable = false;
        try {
            new WebDriverWait(this.driver, (long)timeOut).until((Function)ExpectedConditions.elementToBeClickable((By)this.parseLocatorBy(locator)));
            isClickable = true;
        }
        catch (Exception e) {
            try {
                isClickable = false;
            }
            catch (Throwable throwable) {
                LOG.keywordAppender().append(String.format("%s", isClickable), new Object[0]);
                throw throwable;
            }
            LOG.keywordAppender().append(String.format("%s", isClickable), new Object[0]);
        }
        LOG.keywordAppender().append(String.format("%s", isClickable), new Object[0]);
        return isClickable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitElementToBeInvisible(String locator, int timeOut) {
        LOG.keywordAppender().appendLocator(locator, new Object[0]);
        boolean isInvisible = false;
        try {
            new WebDriverWait(this.driver, (long)timeOut).until((Function)ExpectedConditions.invisibilityOfElementLocated((By)this.parseLocatorBy(locator)));
            isInvisible = true;
        }
        catch (Exception e) {
            try {
                isInvisible = false;
            }
            catch (Throwable throwable) {
                LOG.keywordAppender().append(String.format("%s", isInvisible), new Object[0]);
                throw throwable;
            }
            LOG.keywordAppender().append(String.format("%s", isInvisible), new Object[0]);
        }
        LOG.keywordAppender().append(String.format("%s", isInvisible), new Object[0]);
        return isInvisible;
    }

    private By parseLocatorBy(String locator) {
        String[] stringList = locator.split("=", 2);
        String locatorBy = stringList[0];
        String locatorValue = stringList[1];
        System.out.println("by: " + locatorBy);
        System.out.println("value: " + locatorValue);
        switch (locatorBy) {
            case "id": {
                return By.id((String)locatorValue);
            }
            case "name": {
                return By.name((String)locatorValue);
            }
            case "xpath": {
                return By.xpath((String)locatorValue);
            }
            case "className": {
                return By.className((String)locatorValue);
            }
            case "css": {
                return By.cssSelector((String)locatorValue);
            }
            case "linkText": {
                return By.linkText((String)locatorValue);
            }
            case "partialLinkText": {
                return By.partialLinkText((String)locatorValue);
            }
        }
        LOG.keywordAppender().append("Invalid locatorBy: " + locatorBy, new Object[0]);
        return null;
    }
}

