/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.validation.datetime.base;

import jakarta.validation.ClockProvider;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;

public abstract class BaseValidator<A extends Annotation, T>
implements ConstraintValidator<A, T> {
    private final Function<A, BiPredicate<T, ClockProvider>> predicateExtractor;
    private Function<A, String> messageExtractor;
    private String defaultMessage;
    private String replacementMessageTemplate;
    private BiPredicate<T, ClockProvider> predicate;
    private String messageTemplate;

    protected BaseValidator(Function<A, BiPredicate<T, ClockProvider>> predicateExtractor) {
        this.predicateExtractor = Objects.requireNonNull(predicateExtractor);
    }

    protected final void useReplacementMessageTemplate(Function<A, String> messageExtractor, String defaultMessage, String replacementMessageTemplate) {
        this.defaultMessage = Objects.requireNonNull(defaultMessage);
        this.messageExtractor = Objects.requireNonNull(messageExtractor);
        this.replacementMessageTemplate = Objects.requireNonNull(replacementMessageTemplate);
    }

    public void initialize(A constraintAnnotation) {
        this.initializePredicate(constraintAnnotation);
        this.initializeMessage(constraintAnnotation);
    }

    private void initializePredicate(A constraintAnnotation) {
        this.predicate = this.predicateExtractor.apply(constraintAnnotation);
    }

    private void initializeMessage(A constraintAnnotation) {
        String configuredMessage;
        if (this.messageExtractor != null && (configuredMessage = this.messageExtractor.apply(constraintAnnotation)).equals(this.defaultMessage)) {
            this.messageTemplate = this.replacementMessageTemplate;
        }
    }

    public boolean isValid(T value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        boolean valid = this.predicate.test(value, context.getClockProvider());
        if (!valid && this.messageTemplate != null) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.messageTemplate).addConstraintViolation();
        }
        return valid;
    }

    protected static <T> BiPredicate<T, T> not(BiPredicate<T, T> predicate) {
        return predicate.negate();
    }

    protected static Instant plus(Instant instant, TemporalAmount amount) {
        if (amount instanceof Duration) {
            return instant.plus(amount);
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        zonedDateTime = zonedDateTime.plus(amount);
        return zonedDateTime.toInstant();
    }

    protected static Instant minus(Instant instant, TemporalAmount amount) {
        if (amount instanceof Duration) {
            return instant.minus(amount);
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        zonedDateTime = zonedDateTime.minus(amount);
        return zonedDateTime.toInstant();
    }
}

