/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.validation.datetime.base;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.annotation.Annotation;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Objects;

public abstract class CalendarValidator<A extends Annotation>
implements ConstraintValidator<A, Calendar> {
    private final ConstraintValidator<A, ? super ZonedDateTime> validator;

    protected CalendarValidator(ConstraintValidator<A, ? super ZonedDateTime> validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    public void initialize(A constraintAnnotation) {
        this.validator.initialize(constraintAnnotation);
    }

    public boolean isValid(Calendar value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        return this.validator.isValid((Object)this.toZonedDateTime(value), context);
    }

    private ZonedDateTime toZonedDateTime(Calendar calendar) {
        ZoneId zoneId = calendar.getTimeZone().toZoneId();
        return ZonedDateTime.ofInstant(calendar.toInstant(), zoneId);
    }
}

