/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.validation.datetime.base;

import com.github.robtimus.validation.datetime.base.BaseValidator;
import com.github.robtimus.validation.datetime.base.ZoneIdUtils;
import jakarta.validation.ClockProvider;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;

public abstract class FieldValidator<A extends Annotation, T extends TemporalAccessor>
extends BaseValidator<A, T> {
    protected FieldValidator(Function<A, TemporalField> fieldExtractor, Function<A, String> zoneIdExtractor, BiFunction<T, ZoneId, TemporalAccessor> zoneIdApplier, Function<A, BiPredicate<Integer, ClockProvider>> fieldPredicateExtractor) {
        super(FieldValidator.fieldPredicate(fieldExtractor, zoneIdExtractor, zoneIdApplier, fieldPredicateExtractor));
    }

    protected FieldValidator(TemporalField field, Function<A, String> zoneIdExtractor, BiFunction<T, ZoneId, TemporalAccessor> zoneIdApplier, Function<A, BiPredicate<Integer, ClockProvider>> fieldPredicateExtractor) {
        this(FieldValidator.fieldExtractor(field), zoneIdExtractor, zoneIdApplier, fieldPredicateExtractor);
    }

    private static <A> Function<A, TemporalField> fieldExtractor(TemporalField field) {
        Objects.requireNonNull(field);
        return annotation -> field;
    }

    private static <A, T extends TemporalAccessor> Function<A, BiPredicate<T, ClockProvider>> fieldPredicate(Function<A, TemporalField> fieldExtractor, Function<A, String> zoneIdExtractor, BiFunction<T, ZoneId, TemporalAccessor> zoneIdApplier, Function<A, BiPredicate<Integer, ClockProvider>> fieldPredicateExtractor) {
        Objects.requireNonNull(fieldExtractor);
        Objects.requireNonNull(zoneIdExtractor);
        Objects.requireNonNull(zoneIdApplier);
        Objects.requireNonNull(fieldPredicateExtractor);
        return annotation -> {
            TemporalField field = (TemporalField)fieldExtractor.apply(annotation);
            ZoneId zoneId = ZoneIdUtils.extractZoneId(annotation, zoneIdExtractor);
            BiPredicate fieldPredicate = (BiPredicate)fieldPredicateExtractor.apply(annotation);
            return (value, clockProvider) -> {
                TemporalAccessor temporalAccessor = zoneId == null ? value : (TemporalAccessor)zoneIdApplier.apply(value, zoneId);
                int fieldValue = temporalAccessor.get(field);
                return fieldPredicate.test(fieldValue, clockProvider);
            };
        };
    }

    public static abstract class ForZonedDateTime<A extends Annotation>
    extends FieldValidator<A, ZonedDateTime> {
        protected ForZonedDateTime(Function<A, TemporalField> fieldExtractor, Function<A, String> zoneIdExtractor, Function<A, BiPredicate<Integer, ClockProvider>> fieldPredicateExtractor) {
            super(fieldExtractor, zoneIdExtractor, ZonedDateTime::withZoneSameInstant, fieldPredicateExtractor);
        }

        protected ForZonedDateTime(TemporalField field, Function<A, String> zoneIdExtractor, Function<A, BiPredicate<Integer, ClockProvider>> fieldPredicateExtractor) {
            this(FieldValidator.fieldExtractor(field), zoneIdExtractor, fieldPredicateExtractor);
        }
    }

    public static abstract class ForOffsetTime<A extends Annotation>
    extends FieldValidator<A, OffsetTime> {
        protected ForOffsetTime(Function<A, TemporalField> fieldExtractor, Function<A, String> zoneIdExtractor, Function<A, BiPredicate<Integer, ClockProvider>> fieldPredicateExtractor) {
            super(fieldExtractor, zoneIdExtractor, ForOffsetTime::applyZoneId, fieldPredicateExtractor);
        }

        protected ForOffsetTime(TemporalField field, Function<A, String> zoneIdExtractor, Function<A, BiPredicate<Integer, ClockProvider>> fieldPredicateExtractor) {
            this(FieldValidator.fieldExtractor(field), zoneIdExtractor, fieldPredicateExtractor);
        }

        private static OffsetTime applyZoneId(OffsetTime offsetTime, ZoneId zoneId) {
            return offsetTime.atDate(LocalDate.now()).atZoneSameInstant(zoneId).toOffsetDateTime().toOffsetTime();
        }
    }

    public static abstract class ForInstant<A extends Annotation>
    extends FieldValidator<A, Instant> {
        protected ForInstant(Function<A, TemporalField> fieldExtractor, Function<A, String> zoneIdExtractor, Function<A, BiPredicate<Integer, ClockProvider>> fieldPredicateExtractor) {
            super(fieldExtractor, ZoneIdUtils.nonProvidedZoneId(zoneIdExtractor), Instant::atZone, fieldPredicateExtractor);
        }

        protected ForInstant(TemporalField field, Function<A, String> zoneIdExtractor, Function<A, BiPredicate<Integer, ClockProvider>> fieldPredicateExtractor) {
            this(FieldValidator.fieldExtractor(field), zoneIdExtractor, fieldPredicateExtractor);
        }
    }

    public static abstract class WithoutZoneId<A extends Annotation, T extends TemporalAccessor>
    extends FieldValidator<A, T> {
        protected WithoutZoneId(Function<A, TemporalField> fieldExtractor, Function<A, String> zoneIdExtractor, Function<A, BiPredicate<Integer, ClockProvider>> fieldPredicateExtractor) {
            super(fieldExtractor, ZoneIdUtils.systemOnlyZoneId(zoneIdExtractor), (T t, ZoneId z) -> t, fieldPredicateExtractor);
        }

        protected WithoutZoneId(TemporalField field, Function<A, String> zoneIdExtractor, Function<A, BiPredicate<Integer, ClockProvider>> fieldPredicateExtractor) {
            this(FieldValidator.fieldExtractor(field), zoneIdExtractor, fieldPredicateExtractor);
        }
    }
}

