/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.validation.datetime.base;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.List;

final class ISODuration
implements TemporalAmount {
    private final Period period;
    private final Duration duration;

    private ISODuration(Period period, Duration duration) {
        this.period = period;
        this.duration = duration;
    }

    @Override
    public long get(TemporalUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<TemporalUnit> getUnits() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        return this.period.addTo(this.duration.addTo(temporal));
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        return this.period.subtractFrom(this.duration.subtractFrom(temporal));
    }

    static TemporalAmount parse(String text) {
        String upperCaseText = text.toUpperCase();
        int timeIndex = upperCaseText.indexOf(84);
        if (timeIndex == -1) {
            return Period.parse(text);
        }
        int periodIndex = upperCaseText.indexOf(80);
        if (timeIndex == periodIndex + 1) {
            return Duration.parse(text);
        }
        Period period = Period.parse(text.substring(0, timeIndex));
        Duration duration = Duration.parse(text.substring(0, periodIndex + 1) + text.substring(timeIndex));
        return new ISODuration(period, duration);
    }
}

