/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.validation.datetime.base;

import com.github.robtimus.validation.datetime.base.MomentValueValidator;
import com.github.robtimus.validation.datetime.base.PartValidator;
import com.github.robtimus.validation.datetime.base.ZoneIdUtils;
import java.lang.annotation.Annotation;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;

public abstract class MomentPartValidator<A extends Annotation, T extends TemporalAccessor, P extends TemporalAccessor>
extends PartValidator<A, T, P> {
    protected MomentPartValidator(Function<A, String> momentExtractor, Function<String, P> momentParser, Function<Clock, P> momentCreator, Function<A, String> zoneIdExtractor, BiFunction<T, ZoneId, P> partExtractor, BiPredicate<P, P> validPredicate) {
        super(zoneIdExtractor, partExtractor, MomentValueValidator.momentPredicate(momentExtractor, momentParser, momentCreator, validPredicate));
    }

    protected MomentPartValidator(Function<A, String> momentExtractor, Function<String, P> momentParser, Function<Clock, P> momentCreator, Function<A, String> durationExtractor, BiFunction<P, TemporalAmount, P> durationApplier, Function<A, String> zoneIdExtractor, BiFunction<T, ZoneId, P> partExtractor, BiPredicate<P, P> validPredicate) {
        super(zoneIdExtractor, partExtractor, MomentValueValidator.momentPredicate(momentExtractor, momentParser, momentCreator, durationExtractor, durationApplier, validPredicate));
    }

    protected MomentPartValidator(Function<A, String> momentExtractor, Function<String, P> momentParser, Function<Clock, P> momentCreator, Function<A, String> zoneIdExtractor, Function<T, P> partExtractor, BiFunction<T, ZoneId, ZonedDateTime> zoneIdApplier, Function<ZonedDateTime, P> zonedDateTimePartExtractor, BiPredicate<P, P> validPredicate) {
        this(momentExtractor, momentParser, momentCreator, zoneIdExtractor, MomentPartValidator.partExtractor(partExtractor, zoneIdApplier, zonedDateTimePartExtractor), validPredicate);
    }

    protected MomentPartValidator(Function<A, String> momentExtractor, Function<String, P> momentParser, Function<Clock, P> momentCreator, Function<A, String> durationExtractor, BiFunction<P, TemporalAmount, P> durationApplier, Function<A, String> zoneIdExtractor, Function<T, P> partExtractor, BiFunction<T, ZoneId, ZonedDateTime> zoneIdApplier, Function<ZonedDateTime, P> zonedDateTimePartExtractor, BiPredicate<P, P> validPredicate) {
        this(momentExtractor, momentParser, momentCreator, durationExtractor, durationApplier, zoneIdExtractor, MomentPartValidator.partExtractor(partExtractor, zoneIdApplier, zonedDateTimePartExtractor), validPredicate);
    }

    public static abstract class ForZonedDateTime<A extends Annotation, P extends TemporalAccessor>
    extends MomentPartValidator<A, ZonedDateTime, P> {
        protected ForZonedDateTime(Function<A, String> momentExtractor, Function<String, P> momentParser, Function<Clock, P> momentCreator, Function<A, String> zoneIdExtractor, Function<ZonedDateTime, P> partExtractor, BiPredicate<P, P> validPredicate) {
            super(momentExtractor, momentParser, momentCreator, zoneIdExtractor, partExtractor, ZonedDateTime::withZoneSameInstant, partExtractor, validPredicate);
        }

        protected ForZonedDateTime(Function<A, String> momentExtractor, Function<String, P> momentParser, Function<Clock, P> momentCreator, Function<A, String> durationExtractor, BiFunction<P, TemporalAmount, P> durationApplier, Function<A, String> zoneIdExtractor, Function<ZonedDateTime, P> partExtractor, BiPredicate<P, P> validPredicate) {
            super(momentExtractor, momentParser, momentCreator, durationExtractor, durationApplier, zoneIdExtractor, partExtractor, ZonedDateTime::withZoneSameInstant, partExtractor, validPredicate);
        }
    }

    public static abstract class ForInstant<A extends Annotation, P extends TemporalAccessor>
    extends MomentPartValidator<A, Instant, P> {
        protected ForInstant(Function<A, String> momentExtractor, Function<String, P> momentParser, Function<Clock, P> momentCreator, Function<A, String> zoneIdExtractor, Function<ZonedDateTime, P> partExtractor, BiPredicate<P, P> validPredicate) {
            super(momentExtractor, momentParser, momentCreator, ZoneIdUtils.nonProvidedZoneId(zoneIdExtractor), ForInstant.partExtractor(partExtractor), validPredicate);
        }

        protected ForInstant(Function<A, String> momentExtractor, Function<String, P> momentParser, Function<Clock, P> momentCreator, Function<A, String> durationExtractor, BiFunction<P, TemporalAmount, P> durationApplier, Function<A, String> zoneIdExtractor, Function<ZonedDateTime, P> partExtractor, BiPredicate<P, P> validPredicate) {
            super(momentExtractor, momentParser, momentCreator, durationExtractor, durationApplier, ZoneIdUtils.nonProvidedZoneId(zoneIdExtractor), ForInstant.partExtractor(partExtractor), validPredicate);
        }

        private static <P> BiFunction<Instant, ZoneId, P> partExtractor(Function<ZonedDateTime, P> partExtractor) {
            Objects.requireNonNull(partExtractor);
            return (t, z) -> partExtractor.apply(t.atZone((ZoneId)z));
        }
    }

    public static abstract class WithoutZoneId<A extends Annotation, T extends TemporalAccessor, P extends TemporalAccessor>
    extends MomentPartValidator<A, T, P> {
        protected WithoutZoneId(Function<A, String> momentExtractor, Function<String, P> momentParser, Function<Clock, P> momentCreator, Function<A, String> zoneIdExtractor, Function<T, P> partExtractor, BiPredicate<P, P> validPredicate) {
            super(momentExtractor, momentParser, momentCreator, ZoneIdUtils.systemOnlyZoneId(zoneIdExtractor), WithoutZoneId.partExtractor(partExtractor), validPredicate);
        }

        protected WithoutZoneId(Function<A, String> momentExtractor, Function<String, P> momentParser, Function<Clock, P> momentCreator, Function<A, String> durationExtractor, BiFunction<P, TemporalAmount, P> durationApplier, Function<A, String> zoneIdExtractor, Function<T, P> partExtractor, BiPredicate<P, P> validPredicate) {
            super(momentExtractor, momentParser, momentCreator, durationExtractor, durationApplier, ZoneIdUtils.systemOnlyZoneId(zoneIdExtractor), WithoutZoneId.partExtractor(partExtractor), validPredicate);
        }

        private static <T, P> BiFunction<T, ZoneId, P> partExtractor(Function<T, P> partExtractor) {
            Objects.requireNonNull(partExtractor);
            return (t, z) -> partExtractor.apply(t);
        }
    }
}

