/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.validation.datetime.base;

import com.github.robtimus.validation.datetime.base.ISODuration;
import com.github.robtimus.validation.datetime.base.ValueValidator;
import jakarta.validation.ClockProvider;
import java.lang.annotation.Annotation;
import java.time.Clock;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;

public abstract class MomentValueValidator<A extends Annotation, T extends TemporalAccessor>
extends ValueValidator<A, T> {
    public static final String NOW = "now";

    protected MomentValueValidator(Function<A, String> momentExtractor, Function<String, T> momentParser, Function<Clock, T> momentCreator, BiPredicate<T, T> validPredicate) {
        super(MomentValueValidator.momentPredicate(momentExtractor, momentParser, momentCreator, validPredicate));
    }

    protected MomentValueValidator(Function<A, String> momentExtractor, Function<String, T> momentParser, Function<Clock, T> momentCreator, Function<A, String> durationExtractor, BiFunction<T, TemporalAmount, T> durationApplier, BiPredicate<T, T> validPredicate) {
        super(MomentValueValidator.momentPredicate(momentExtractor, momentParser, momentCreator, durationExtractor, durationApplier, validPredicate));
    }

    static <A, T> Function<A, BiPredicate<T, ClockProvider>> momentPredicate(Function<A, String> momentExtractor, Function<String, T> momentParser, Function<Clock, T> momentCreator, BiPredicate<T, T> validPredicate) {
        Objects.requireNonNull(momentExtractor);
        Objects.requireNonNull(momentParser);
        Objects.requireNonNull(momentCreator);
        Objects.requireNonNull(validPredicate);
        return annotation -> {
            Object moment = MomentValueValidator.extractMoment(annotation, momentExtractor, momentParser);
            return (value, clockProvider) -> {
                Object temporalAccessor = moment != null ? moment : momentCreator.apply(clockProvider.getClock());
                return validPredicate.test(value, temporalAccessor);
            };
        };
    }

    static <A, T> Function<A, BiPredicate<T, ClockProvider>> momentPredicate(Function<A, String> momentExtractor, Function<String, T> momentParser, Function<Clock, T> momentCreator, Function<A, String> durationExtractor, BiFunction<T, TemporalAmount, T> durationApplier, BiPredicate<T, T> validPredicate) {
        Objects.requireNonNull(momentExtractor);
        Objects.requireNonNull(momentParser);
        Objects.requireNonNull(momentCreator);
        Objects.requireNonNull(durationExtractor);
        Objects.requireNonNull(durationApplier);
        Objects.requireNonNull(validPredicate);
        return annotation -> {
            Object moment = MomentValueValidator.extractMoment(annotation, momentExtractor, momentParser);
            TemporalAmount duration = MomentValueValidator.extractDuration(annotation, momentCreator, durationExtractor, durationApplier);
            return (value, clockProvider) -> {
                Object temporalAccessor = moment != null ? moment : momentCreator.apply(clockProvider.getClock());
                temporalAccessor = durationApplier.apply(temporalAccessor, duration);
                return validPredicate.test(value, temporalAccessor);
            };
        };
    }

    private static <A, T> T extractMoment(A annotation, Function<A, String> momentExtractor, Function<String, T> momentParser) {
        String text = momentExtractor.apply(annotation);
        return NOW.equals(text) ? null : (T)momentParser.apply(text);
    }

    private static <A, T> TemporalAmount extractDuration(A annotation, Function<Clock, T> momentCreator, Function<A, String> durationExtractor, BiFunction<T, TemporalAmount, T> durationApplier) {
        String text = durationExtractor.apply(annotation);
        TemporalAmount duration = ISODuration.parse(text);
        durationApplier.apply(momentCreator.apply(Clock.systemUTC()), duration);
        return duration;
    }
}

