/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.validation.datetime.base;

import com.github.robtimus.validation.datetime.base.BaseValidator;
import com.github.robtimus.validation.datetime.base.ZoneIdUtils;
import jakarta.validation.ClockProvider;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;

public abstract class PartValidator<A extends Annotation, T extends TemporalAccessor, P extends TemporalAccessor>
extends BaseValidator<A, T> {
    protected PartValidator(Function<A, String> zoneIdExtractor, BiFunction<T, ZoneId, P> partExtractor, Function<A, BiPredicate<P, ClockProvider>> partPredicateExtractor) {
        super(PartValidator.partPredicate(zoneIdExtractor, partExtractor, partPredicateExtractor));
    }

    protected PartValidator(Function<A, String> zoneIdExtractor, Function<T, P> partExtractor, BiFunction<T, ZoneId, ZonedDateTime> zoneIdApplier, Function<ZonedDateTime, P> zonedDateTimePartExtractor, Function<A, BiPredicate<P, ClockProvider>> partPredicateExtractor) {
        this(zoneIdExtractor, PartValidator.partExtractor(partExtractor, zoneIdApplier, zonedDateTimePartExtractor), partPredicateExtractor);
    }

    private static <A, T, P> Function<A, BiPredicate<T, ClockProvider>> partPredicate(Function<A, String> zoneIdExtractor, BiFunction<T, ZoneId, P> partExtractor, Function<A, BiPredicate<P, ClockProvider>> partPredicateExtractor) {
        Objects.requireNonNull(zoneIdExtractor);
        Objects.requireNonNull(partExtractor);
        Objects.requireNonNull(partExtractor);
        return annotation -> {
            ZoneId zoneId = ZoneIdUtils.extractZoneId(annotation, zoneIdExtractor);
            BiPredicate partPredicate = (BiPredicate)partPredicateExtractor.apply(annotation);
            return (value, clockProvider) -> {
                Object part = partExtractor.apply(value, zoneId);
                return partPredicate.test(part, clockProvider);
            };
        };
    }

    static <T, P> BiFunction<T, ZoneId, P> partExtractor(Function<T, P> partExtractor, BiFunction<T, ZoneId, ZonedDateTime> zoneIdApplier, Function<ZonedDateTime, P> zonedDateTimePartExtractor) {
        Objects.requireNonNull(partExtractor);
        Objects.requireNonNull(zoneIdApplier);
        Objects.requireNonNull(zonedDateTimePartExtractor);
        return (t, z) -> z == null ? partExtractor.apply(t) : zonedDateTimePartExtractor.apply((ZonedDateTime)zoneIdApplier.apply((Object)t, (ZoneId)z));
    }

    public static abstract class ForZonedDateTime<A extends Annotation, P extends TemporalAccessor>
    extends PartValidator<A, ZonedDateTime, P> {
        protected ForZonedDateTime(Function<A, String> zoneIdExtractor, Function<ZonedDateTime, P> partExtractor, Function<A, BiPredicate<P, ClockProvider>> partPredicateExtractor) {
            super(zoneIdExtractor, partExtractor, ZonedDateTime::withZoneSameInstant, partExtractor, partPredicateExtractor);
        }
    }

    public static abstract class ForInstant<A extends Annotation, P extends TemporalAccessor>
    extends PartValidator<A, Instant, P> {
        protected ForInstant(Function<A, String> zoneIdExtractor, Function<ZonedDateTime, P> partExtractor, Function<A, BiPredicate<P, ClockProvider>> partPredicateExtractor) {
            super(ZoneIdUtils.nonProvidedZoneId(zoneIdExtractor), ForInstant.partExtractor(partExtractor), partPredicateExtractor);
        }

        private static <P> BiFunction<Instant, ZoneId, P> partExtractor(Function<ZonedDateTime, P> partExtractor) {
            Objects.requireNonNull(partExtractor);
            return (t, z) -> partExtractor.apply(t.atZone((ZoneId)z));
        }
    }

    public static abstract class WithoutZoneId<A extends Annotation, T extends TemporalAccessor, P extends TemporalAccessor>
    extends PartValidator<A, T, P> {
        protected WithoutZoneId(Function<A, String> zoneIdExtractor, Function<T, P> partExtractor, Function<A, BiPredicate<P, ClockProvider>> partPredicateExtractor) {
            super(ZoneIdUtils.systemOnlyZoneId(zoneIdExtractor), WithoutZoneId.partExtractor(partExtractor), partPredicateExtractor);
        }

        private static <T, P> BiFunction<T, ZoneId, P> partExtractor(Function<T, P> partExtractor) {
            Objects.requireNonNull(partExtractor);
            return (t, z) -> partExtractor.apply(t);
        }
    }
}

