/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.validation.datetime.base;

import java.lang.annotation.Annotation;
import java.time.ZoneId;
import java.util.Objects;
import java.util.function.Function;

public final class ZoneIdUtils {
    public static final String SYSTEM_ZONE_ID = "system";
    public static final String PROVIDED_ZONE_ID = "provided";

    private ZoneIdUtils() {
    }

    static <A> ZoneId extractZoneId(A annotation, Function<A, String> zoneIdExtractor) {
        String text = zoneIdExtractor.apply(annotation);
        return ZoneIdUtils.toZoneId(text);
    }

    public static ZoneId toZoneId(String text) {
        Objects.requireNonNull(text);
        switch (text) {
            case "system": {
                return ZoneId.systemDefault();
            }
            case "provided": {
                return null;
            }
        }
        return ZoneId.of(text);
    }

    public static <A extends Annotation> Function<A, String> systemOnlyZoneId(Function<A, String> zoneIdExtractor) {
        Objects.requireNonNull(zoneIdExtractor);
        return constraint -> {
            String zoneId = (String)zoneIdExtractor.apply(constraint);
            if (!SYSTEM_ZONE_ID.equals(zoneId)) {
                throw new IllegalStateException(String.format("zoneId should be '%s', is '%s'", SYSTEM_ZONE_ID, zoneId));
            }
            return zoneId;
        };
    }

    public static <A extends Annotation> Function<A, String> nonProvidedZoneId(Function<A, String> zoneIdExtractor) {
        Objects.requireNonNull(zoneIdExtractor);
        return constraint -> {
            String zoneId = (String)zoneIdExtractor.apply(constraint);
            if (PROVIDED_ZONE_ID.equals(zoneId)) {
                throw new IllegalStateException(String.format("zoneId should not be '%s'", PROVIDED_ZONE_ID));
            }
            return zoneId;
        };
    }
}

