/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.validation.hour.validators;

import com.github.robtimus.validation.datetime.base.CalendarValidator;
import com.github.robtimus.validation.datetime.base.DateValidator;
import com.github.robtimus.validation.datetime.base.FieldValidator;
import com.github.robtimus.validation.hour.HourIn;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Arrays;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.validation.ClockProvider;
import javax.validation.ConstraintValidator;

public final class HourInValidator {
    private static final Function<HourIn, BiPredicate<Integer, ClockProvider>> PREDICATE_EXTRACTOR = annotation -> {
        int[] allowedValues = annotation.value();
        Arrays.sort(allowedValues);
        return (value, provider) -> Arrays.binarySearch(allowedValues, value) >= 0;
    };

    private HourInValidator() {
    }

    public static class ForZonedDateTime
    extends FieldValidator.ForZonedDateTime<HourIn> {
        public ForZonedDateTime() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourIn::zoneId, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForOffsetTime
    extends FieldValidator.ForOffsetTime<HourIn> {
        public ForOffsetTime() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourIn::zoneId, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForOffsetDateTime
    extends FieldValidator<HourIn, OffsetDateTime> {
        public ForOffsetDateTime() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourIn::zoneId, OffsetDateTime::atZoneSameInstant, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForLocalTime
    extends FieldValidator.WithoutZoneId<HourIn, LocalTime> {
        public ForLocalTime() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourIn::zoneId, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForLocalDateTime
    extends FieldValidator.WithoutZoneId<HourIn, LocalDateTime> {
        public ForLocalDateTime() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourIn::zoneId, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForInstant
    extends FieldValidator.ForInstant<HourIn> {
        public ForInstant() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourIn::zoneId, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForCalendar
    extends CalendarValidator<HourIn> {
        public ForCalendar() {
            super((ConstraintValidator)new ForZonedDateTime());
        }
    }

    public static class ForDate
    extends DateValidator<HourIn> {
        public ForDate() {
            super((ConstraintValidator)new ForInstant());
        }
    }
}

