/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.validation.hour.validators;

import com.github.robtimus.validation.datetime.base.CalendarValidator;
import com.github.robtimus.validation.datetime.base.DateValidator;
import com.github.robtimus.validation.datetime.base.FieldValidator;
import com.github.robtimus.validation.hour.HourIs;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.validation.ClockProvider;
import javax.validation.ConstraintValidator;

public final class HourIsValidator {
    private static final Function<HourIs, BiPredicate<Integer, ClockProvider>> PREDICATE_EXTRACTOR = annotation -> {
        int allowedValue = annotation.value();
        return (value, provider) -> value == allowedValue;
    };

    private HourIsValidator() {
    }

    public static class ForZonedDateTime
    extends FieldValidator.ForZonedDateTime<HourIs> {
        public ForZonedDateTime() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourIs::zoneId, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForOffsetTime
    extends FieldValidator.ForOffsetTime<HourIs> {
        public ForOffsetTime() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourIs::zoneId, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForOffsetDateTime
    extends FieldValidator<HourIs, OffsetDateTime> {
        public ForOffsetDateTime() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourIs::zoneId, OffsetDateTime::atZoneSameInstant, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForLocalTime
    extends FieldValidator.WithoutZoneId<HourIs, LocalTime> {
        public ForLocalTime() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourIs::zoneId, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForLocalDateTime
    extends FieldValidator.WithoutZoneId<HourIs, LocalDateTime> {
        public ForLocalDateTime() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourIs::zoneId, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForInstant
    extends FieldValidator.ForInstant<HourIs> {
        public ForInstant() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourIs::zoneId, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForCalendar
    extends CalendarValidator<HourIs> {
        public ForCalendar() {
            super((ConstraintValidator)new ForZonedDateTime());
        }
    }

    public static class ForDate
    extends DateValidator<HourIs> {
        public ForDate() {
            super((ConstraintValidator)new ForInstant());
        }
    }
}

