/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.validation.hour.validators;

import com.github.robtimus.validation.datetime.base.CalendarValidator;
import com.github.robtimus.validation.datetime.base.DateValidator;
import com.github.robtimus.validation.datetime.base.FieldValidator;
import com.github.robtimus.validation.hour.HourNotIn;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Arrays;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.validation.ClockProvider;
import javax.validation.ConstraintValidator;

public final class HourNotInValidator {
    private static final Function<HourNotIn, BiPredicate<Integer, ClockProvider>> PREDICATE_EXTRACTOR = annotation -> {
        int[] disallowedValues = annotation.value();
        Arrays.sort(disallowedValues);
        return (value, provider) -> Arrays.binarySearch(disallowedValues, value) < 0;
    };

    private HourNotInValidator() {
    }

    public static class ForZonedDateTime
    extends FieldValidator.ForZonedDateTime<HourNotIn> {
        public ForZonedDateTime() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourNotIn::zoneId, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForOffsetTime
    extends FieldValidator.ForOffsetTime<HourNotIn> {
        public ForOffsetTime() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourNotIn::zoneId, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForOffsetDateTime
    extends FieldValidator<HourNotIn, OffsetDateTime> {
        public ForOffsetDateTime() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourNotIn::zoneId, OffsetDateTime::atZoneSameInstant, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForLocalTime
    extends FieldValidator.WithoutZoneId<HourNotIn, LocalTime> {
        public ForLocalTime() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourNotIn::zoneId, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForLocalDateTime
    extends FieldValidator.WithoutZoneId<HourNotIn, LocalDateTime> {
        public ForLocalDateTime() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourNotIn::zoneId, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForInstant
    extends FieldValidator.ForInstant<HourNotIn> {
        public ForInstant() {
            super((TemporalField)ChronoField.HOUR_OF_DAY, HourNotIn::zoneId, PREDICATE_EXTRACTOR);
        }
    }

    public static class ForCalendar
    extends CalendarValidator<HourNotIn> {
        public ForCalendar() {
            super((ConstraintValidator)new ForZonedDateTime());
        }
    }

    public static class ForDate
    extends DateValidator<HourNotIn> {
        public ForDate() {
            super((ConstraintValidator)new ForInstant());
        }
    }
}

