/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import com.github.robtimus.io.stream.Messages;
import com.github.robtimus.io.stream.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Objects;

public final class AsciiInputStream
extends InputStream {
    private static final int READ_BUFFER_SIZE = 1024;
    private final Reader input;
    private char[] readBuffer;

    public AsciiInputStream(Reader input) {
        this.input = Objects.requireNonNull(input);
    }

    @Override
    public int read() throws IOException {
        int read = this.input.read();
        return read == -1 ? -1 : this.convert((char)read) & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        char[] c;
        StreamUtils.checkOffsetAndLength(b, off, len);
        if (len <= 1024) {
            if (this.readBuffer == null) {
                this.readBuffer = new char[1024];
            }
            c = this.readBuffer;
        } else {
            c = new char[len];
        }
        int read = this.input.read(c, 0, len);
        if (read == -1) {
            return -1;
        }
        this.convert(c, b, off, read);
        return read;
    }

    @Override
    public int available() throws IOException {
        return this.input.ready() ? 1 : 0;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    private byte convert(char c) throws IOException {
        if (c > '\u007f') {
            throw new IOException(Messages.ascii.invalidChar.get(Character.valueOf(c)));
        }
        return (byte)c;
    }

    private void convert(char[] c, byte[] b, int off, int len) throws IOException {
        int i = 0;
        int j = off;
        while (i < len) {
            b[j] = this.convert(c[i]);
            ++i;
            ++j;
        }
    }
}

