/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import com.github.robtimus.io.stream.Messages;
import com.github.robtimus.io.stream.StreamUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Objects;

public final class AsciiOutputStream
extends OutputStream {
    private static final int WRITE_BUFFER_SIZE = 1024;
    private final Writer output;
    private char[] writeBuffer;

    public AsciiOutputStream(Writer output) {
        this.output = Objects.requireNonNull(output);
    }

    @Override
    public void write(int b) throws IOException {
        this.output.write(this.convert((byte)b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        char[] c;
        StreamUtils.checkOffsetAndLength(b, off, len);
        if (len <= 1024) {
            if (this.writeBuffer == null) {
                this.writeBuffer = new char[1024];
            }
            c = this.writeBuffer;
        } else {
            c = new char[len];
        }
        this.convert(b, c, off, len);
        this.output.write(c, 0, len);
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }

    private char convert(byte b) throws IOException {
        if (b < 0) {
            throw new IOException(Messages.ascii.invalidByte.get(b));
        }
        return (char)b;
    }

    private void convert(byte[] b, char[] c, int off, int len) throws IOException {
        int i = off;
        for (int j = 0; j < len; ++j) {
            c[j] = this.convert(b[i]);
            ++i;
        }
    }
}

