/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import com.github.robtimus.io.stream.Messages;
import com.github.robtimus.io.stream.PipeInputStream;
import com.github.robtimus.io.stream.PipeOutputStream;
import com.github.robtimus.io.stream.StreamUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class BinaryPipe {
    private static final long AWAIT_TIME = TimeUnit.SECONDS.toNanos(1L);
    private final PipeInputStream input;
    private final PipeOutputStream output;
    private final byte[] single = new byte[1];
    private byte[] data;
    private int start;
    private int end;
    private final Lock lock = new ReentrantLock();
    private final Condition closedOrNotEmpty = this.lock.newCondition();
    private final Condition closedOrEmpty = this.lock.newCondition();
    private boolean closed = false;
    private IOException readError = null;
    private IOException writeError = null;
    private Thread readThread;
    private Thread writeThread;

    public BinaryPipe() {
        this.input = new PipeInputStream(this);
        this.output = new PipeOutputStream(this);
    }

    public PipeInputStream input() {
        return this.input;
    }

    public PipeOutputStream output() {
        return this.output;
    }

    public boolean closed() {
        this.lock.lock();
        try {
            boolean bl = this.closed;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    int read() throws IOException {
        this.lock.lock();
        try {
            this.readThread = Thread.currentThread();
            while (!this.closed && this.start == this.end && !this.writerDied()) {
                this.await(this.closedOrNotEmpty);
            }
            this.throwWriteError();
            if (this.start < this.end) {
                byte b = this.data[this.start++];
                this.checkEmpty();
                int n = b & 0xFF;
                return n;
            }
            if (this.closed) {
                int n = -1;
                return n;
            }
            throw this.writerDiedException();
        }
        finally {
            this.lock.unlock();
        }
    }

    int read(byte[] b, int off, int len) throws IOException {
        StreamUtils.checkOffsetAndLength(b, off, len);
        if (len == 0) {
            return 0;
        }
        this.lock.lock();
        try {
            this.readThread = Thread.currentThread();
            while (!this.closed && this.start == this.end && !this.writerDied()) {
                this.await(this.closedOrNotEmpty);
            }
            this.throwWriteError();
            if (this.start < this.end) {
                int result = Math.min(len, this.end - this.start);
                System.arraycopy(this.data, this.start, b, off, result);
                this.start += result;
                this.checkEmpty();
                int n = result;
                return n;
            }
            if (this.closed) {
                int n = -1;
                return n;
            }
            throw this.writerDiedException();
        }
        finally {
            this.lock.unlock();
        }
    }

    long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        this.lock.lock();
        try {
            this.readThread = Thread.currentThread();
            while (!this.closed && this.start == this.end && !this.writerDied()) {
                this.await(this.closedOrNotEmpty);
            }
            this.throwWriteError();
            if (this.start < this.end) {
                long result = Math.min(n, (long)this.end - (long)this.start);
                this.start = (int)((long)this.start + result);
                this.checkEmpty();
                long l = result;
                return l;
            }
            if (this.closed) {
                long l = 0L;
                return l;
            }
            throw this.writerDiedException();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkEmpty() {
        if (this.start == this.end) {
            this.data = null;
            this.closedOrEmpty.signalAll();
        }
    }

    int available() throws IOException {
        this.lock.lock();
        try {
            this.readThread = Thread.currentThread();
            this.throwWriteError();
            int n = this.end - this.start;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    void closeInput() {
        this.lock.lock();
        try {
            this.data = null;
            this.start = 0;
            this.end = 0;
            this.closed = true;
            this.closedOrNotEmpty.signalAll();
            this.closedOrEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    void closeInput(IOException error) {
        this.lock.lock();
        try {
            this.data = null;
            this.start = 0;
            this.end = 0;
            this.closed = true;
            this.readError = error;
            this.closedOrNotEmpty.signalAll();
            this.closedOrEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void throwWriteError() throws IOException {
        if (this.writeError != null) {
            throw this.writeError;
        }
    }

    private boolean writerDied() {
        return this.writeThread != null && !this.writeThread.isAlive();
    }

    private IOException writerDiedException() {
        return new IOException(Messages.pipe.writerDied.get());
    }

    void write(int b) throws IOException {
        this.lock.lock();
        try {
            this.writeThread = Thread.currentThread();
            while (!this.closed && this.start < this.end && !this.readerDied()) {
                this.await(this.closedOrEmpty);
            }
            this.throwReadError();
            this.throwIfClosed();
            if (this.start == this.end) {
                this.single[0] = (byte)b;
                this.data = this.single;
                this.start = 0;
                this.end = 1;
                this.closedOrNotEmpty.signalAll();
            }
            this.awaitDataRead();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(byte[] b, int off, int len) throws IOException {
        StreamUtils.checkOffsetAndLength(b, off, len);
        this.lock.lock();
        try {
            this.writeThread = Thread.currentThread();
            while (!this.closed && this.start < this.end && !this.readerDied()) {
                this.await(this.closedOrEmpty);
            }
            this.throwReadError();
            this.throwIfClosed();
            if (this.start == this.end) {
                this.data = b;
                this.start = off;
                this.end = off + len;
                this.closedOrNotEmpty.signalAll();
            }
            this.awaitDataRead();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void awaitDataRead() throws IOException {
        while (!this.closed && this.start < this.end && !this.readerDied()) {
            this.await(this.closedOrEmpty);
        }
        this.throwReadError();
        this.throwIfClosed();
        if (this.start < this.end) {
            throw this.readerDiedException();
        }
    }

    void flush() throws IOException {
        this.lock.lock();
        try {
            this.writeThread = Thread.currentThread();
            this.throwReadError();
            this.throwIfClosed();
            this.throwIfReaderDied();
        }
        finally {
            this.lock.unlock();
        }
    }

    void closeOutput() {
        this.lock.lock();
        try {
            this.closed = true;
            this.closedOrNotEmpty.signalAll();
            this.closedOrEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    void closeOutput(IOException error) {
        this.lock.lock();
        try {
            this.closed = true;
            this.writeError = error;
            this.closedOrNotEmpty.signalAll();
            this.closedOrEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void throwReadError() throws IOException {
        if (this.readError != null) {
            throw this.readError;
        }
    }

    private void throwIfClosed() throws IOException {
        if (this.closed) {
            throw new IOException(Messages.stream.closed.get());
        }
    }

    private void throwIfReaderDied() throws IOException {
        if (this.readerDied()) {
            throw this.readerDiedException();
        }
    }

    private boolean readerDied() {
        return this.readThread != null && !this.readThread.isAlive();
    }

    private IOException readerDiedException() {
        return new IOException(Messages.pipe.readerDied.get());
    }

    private void await(Condition condition) throws IOException {
        try {
            condition.awaitNanos(AWAIT_TIME);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            InterruptedIOException exception = new InterruptedIOException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }
}

