/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class CapturingReader
extends Reader {
    private final Reader delegate;
    private final StringBuilder captor;
    private final int limit;
    private final long doneAfter;
    private long totalChars = 0L;
    private long mark = 0L;
    private boolean consumed = false;
    private boolean closed = false;
    private Consumer<? super CapturingReader> doneCallback;
    private Consumer<? super CapturingReader> limitReachedCallback;
    private final BiConsumer<? super CapturingReader, ? super IOException> errorCallback;

    public CapturingReader(Reader input, Config config) {
        this.delegate = Objects.requireNonNull(input);
        this.captor = config.expectedCount < 0 ? new StringBuilder() : new StringBuilder(Math.min(config.expectedCount, config.limit));
        this.limit = config.limit;
        this.doneAfter = config.doneAfter;
        this.doneCallback = config.doneCallback;
        this.limitReachedCallback = config.limitReachedCallback;
        this.errorCallback = config.errorCallback;
    }

    @Override
    public int read() throws IOException {
        try {
            int c = this.delegate.read();
            if (c == -1) {
                this.markAsConsumed();
            } else {
                ++this.totalChars;
                if (this.captor.length() < this.limit) {
                    this.captor.append((char)c);
                    this.checkLimitReached();
                }
                this.checkDone();
            }
            return c;
        }
        catch (IOException e) {
            this.onError(e);
            throw e;
        }
    }

    @Override
    public int read(char[] c) throws IOException {
        try {
            int n = this.delegate.read(c);
            if (n == -1) {
                this.markAsConsumed();
            } else {
                this.totalChars += (long)n;
                int allowed = Math.min(this.limit - this.captor.length(), n);
                if (allowed > 0) {
                    this.captor.append(c, 0, allowed);
                    this.checkLimitReached();
                }
                this.checkDone();
            }
            return n;
        }
        catch (IOException e) {
            this.onError(e);
            throw e;
        }
    }

    @Override
    public int read(char[] c, int off, int len) throws IOException {
        try {
            int n = this.delegate.read(c, off, len);
            if (n == -1) {
                this.markAsConsumed();
            } else {
                this.totalChars += (long)n;
                int allowed = Math.min(this.limit - this.captor.length(), n);
                if (allowed > 0) {
                    this.captor.append(c, off, allowed);
                    this.checkLimitReached();
                }
                this.checkDone();
            }
            return n;
        }
        catch (IOException e) {
            this.onError(e);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.delegate.close();
            this.markAsClosed();
        }
        catch (IOException e) {
            this.onError(e);
            throw e;
        }
    }

    @Override
    public void mark(int readlimit) throws IOException {
        try {
            this.delegate.mark(readlimit);
            this.mark = this.totalChars;
        }
        catch (IOException e) {
            this.onError(e);
            throw e;
        }
    }

    @Override
    public void reset() throws IOException {
        try {
            this.delegate.reset();
            this.captor.delete((int)Math.min(this.mark, (long)this.limit), this.captor.length());
            this.totalChars = this.mark;
            this.consumed = false;
        }
        catch (IOException e) {
            this.onError(e);
            throw e;
        }
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    private void markAsConsumed() {
        this.consumed = true;
        if (this.doneCallback != null) {
            this.doneCallback.accept(this);
            this.doneCallback = null;
        }
    }

    private void markAsClosed() {
        this.closed = true;
        if (this.doneCallback != null) {
            this.doneCallback.accept(this);
            this.doneCallback = null;
        }
    }

    private void checkLimitReached() {
        if (this.totalChars >= (long)this.limit && this.limitReachedCallback != null) {
            this.limitReachedCallback.accept(this);
            this.limitReachedCallback = null;
        }
    }

    private void checkDone() {
        if (this.totalChars >= this.doneAfter && this.doneCallback != null) {
            this.doneCallback.accept(this);
            this.doneCallback = null;
        }
    }

    private void onError(IOException error) {
        if (this.errorCallback != null) {
            this.errorCallback.accept(this, error);
        }
    }

    public String captured() {
        return this.captor.toString();
    }

    public long totalChars() {
        return this.totalChars;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public static Config.Builder config() {
        return new Config.Builder();
    }

    public static final class Config {
        private final int limit;
        private final int expectedCount;
        private final long doneAfter;
        private final Consumer<? super CapturingReader> doneCallback;
        private final Consumer<? super CapturingReader> limitReachedCallback;
        private final BiConsumer<? super CapturingReader, ? super IOException> errorCallback;

        private Config(Builder builder) {
            this.limit = builder.limit;
            this.expectedCount = builder.expectedCount;
            this.doneAfter = builder.doneAfter;
            this.doneCallback = builder.doneCallback;
            this.limitReachedCallback = builder.limitReachedCallback;
            this.errorCallback = builder.errorCallback;
        }

        public static final class Builder {
            private int limit = Integer.MAX_VALUE;
            private int expectedCount = -1;
            private long doneAfter = Long.MAX_VALUE;
            private Consumer<? super CapturingReader> doneCallback;
            private Consumer<? super CapturingReader> limitReachedCallback;
            private BiConsumer<? super CapturingReader, ? super IOException> errorCallback;

            private Builder() {
            }

            public Builder withLimit(int limit) {
                if (limit < 0) {
                    throw new IllegalArgumentException(limit + " < 0");
                }
                this.limit = limit;
                return this;
            }

            public Builder withExpectedCount(int expectedCount) {
                this.expectedCount = expectedCount;
                return this;
            }

            public Builder doneAfter(long count) {
                if (count < 0L) {
                    throw new IllegalArgumentException(count + " < 0");
                }
                this.doneAfter = count;
                return this;
            }

            public Builder onDone(Consumer<? super CapturingReader> callback) {
                this.doneCallback = Objects.requireNonNull(callback);
                return this;
            }

            public Builder onLimitReached(Consumer<? super CapturingReader> callback) {
                this.limitReachedCallback = Objects.requireNonNull(callback);
                return this;
            }

            public Builder onError(BiConsumer<? super CapturingReader, ? super IOException> callback) {
                this.errorCallback = Objects.requireNonNull(callback);
                return this;
            }

            public Config build() {
                return new Config(this);
            }
        }
    }
}

