/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class CapturingWriter
extends Writer {
    private final Writer delegate;
    private final StringBuilder captor;
    private final int limit;
    private long totalChars = 0L;
    private boolean closed = false;
    private Consumer<? super CapturingWriter> doneCallback;
    private Consumer<? super CapturingWriter> limitReachedCallback;
    private final BiConsumer<? super CapturingWriter, ? super IOException> errorCallback;

    public CapturingWriter(Writer output, Config config) {
        this.delegate = Objects.requireNonNull(output);
        this.captor = config.expectedCount < 0 ? new StringBuilder() : new StringBuilder(Math.min(config.expectedCount, config.limit));
        this.limit = config.limit;
        this.doneCallback = config.doneCallback;
        this.limitReachedCallback = config.limitReachedCallback;
        this.errorCallback = config.errorCallback;
    }

    @Override
    public void write(int c) throws IOException {
        try {
            this.delegate.write(c);
            ++this.totalChars;
            if (this.captor.length() < this.limit) {
                this.captor.append((char)c);
                this.checkLimitReached();
            }
        }
        catch (IOException e) {
            this.onError(e);
            throw e;
        }
    }

    @Override
    public void write(char[] c) throws IOException {
        try {
            this.delegate.write(c);
            this.totalChars += (long)c.length;
            int allowed = Math.min(this.limit - this.captor.length(), c.length);
            if (allowed > 0) {
                this.captor.append(c, 0, allowed);
                this.checkLimitReached();
            }
        }
        catch (IOException e) {
            this.onError(e);
            throw e;
        }
    }

    @Override
    public void write(char[] c, int off, int len) throws IOException {
        try {
            this.delegate.write(c, off, len);
            this.totalChars += (long)len;
            int allowed = Math.min(this.limit - this.captor.length(), len);
            if (allowed > 0) {
                this.captor.append(c, off, allowed);
                this.checkLimitReached();
            }
        }
        catch (IOException e) {
            this.onError(e);
            throw e;
        }
    }

    @Override
    public void write(String str) throws IOException {
        try {
            this.delegate.write(str);
            this.totalChars += (long)str.length();
            int allowed = Math.min(this.limit - this.captor.length(), str.length());
            if (allowed > 0) {
                this.captor.append(str, 0, allowed);
                this.checkLimitReached();
            }
        }
        catch (IOException e) {
            this.onError(e);
            throw e;
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        try {
            this.delegate.write(str, off, len);
            this.totalChars += (long)len;
            int allowed = Math.min(this.limit - this.captor.length(), len);
            if (allowed > 0) {
                this.captor.append(str, off, off + allowed);
                this.checkLimitReached();
            }
        }
        catch (IOException e) {
            this.onError(e);
            throw e;
        }
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        try {
            this.delegate.append(csq);
            CharSequence cs = csq != null ? csq : "null";
            this.totalChars += (long)cs.length();
            int allowed = Math.min(this.limit - this.captor.length(), cs.length());
            if (allowed > 0) {
                this.captor.append(csq, 0, allowed);
                this.checkLimitReached();
            }
            return this;
        }
        catch (IOException e) {
            this.onError(e);
            throw e;
        }
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        try {
            this.delegate.append(csq, start, end);
            this.totalChars += (long)(end - start);
            int allowed = Math.min(this.limit - this.captor.length(), end - start);
            if (allowed > 0) {
                this.captor.append(csq, start, start + allowed);
                this.checkLimitReached();
            }
            return this;
        }
        catch (IOException e) {
            this.onError(e);
            throw e;
        }
    }

    @Override
    public Writer append(char c) throws IOException {
        try {
            this.delegate.append(c);
            ++this.totalChars;
            if (this.captor.length() < this.limit) {
                this.captor.append(c);
                this.checkLimitReached();
            }
            return this;
        }
        catch (IOException e) {
            this.onError(e);
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.delegate.flush();
        }
        catch (IOException e) {
            this.onError(e);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.delegate.close();
            this.markAsClosed();
        }
        catch (IOException e) {
            this.onError(e);
            throw e;
        }
    }

    public void done() {
        if (this.doneCallback != null) {
            this.doneCallback.accept(this);
            this.doneCallback = null;
        }
    }

    private void markAsClosed() {
        this.closed = true;
        this.done();
    }

    private void checkLimitReached() {
        if (this.totalChars >= (long)this.limit && this.limitReachedCallback != null) {
            this.limitReachedCallback.accept(this);
            this.limitReachedCallback = null;
        }
    }

    private void onError(IOException error) {
        if (this.errorCallback != null) {
            this.errorCallback.accept(this, error);
        }
    }

    public String captured() {
        return this.captor.toString();
    }

    public long totalChars() {
        return this.totalChars;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public static Config.Builder config() {
        return new Config.Builder();
    }

    public static final class Config {
        private final int limit;
        private final int expectedCount;
        private final Consumer<? super CapturingWriter> doneCallback;
        private final Consumer<? super CapturingWriter> limitReachedCallback;
        private final BiConsumer<? super CapturingWriter, ? super IOException> errorCallback;

        private Config(Builder builder) {
            this.limit = builder.limit;
            this.expectedCount = builder.expectedCount;
            this.doneCallback = builder.doneCallback;
            this.limitReachedCallback = builder.limitReachedCallback;
            this.errorCallback = builder.errorCallback;
        }

        public static final class Builder {
            private int limit = Integer.MAX_VALUE;
            private int expectedCount = -1;
            private Consumer<? super CapturingWriter> doneCallback;
            private Consumer<? super CapturingWriter> limitReachedCallback;
            private BiConsumer<? super CapturingWriter, ? super IOException> errorCallback;

            private Builder() {
            }

            public Builder withLimit(int limit) {
                if (limit < 0) {
                    throw new IllegalArgumentException(limit + " < 0");
                }
                this.limit = limit;
                return this;
            }

            public Builder withExpectedCount(int expectedCount) {
                this.expectedCount = expectedCount;
                return this;
            }

            public Builder onDone(Consumer<? super CapturingWriter> callback) {
                this.doneCallback = Objects.requireNonNull(callback);
                return this;
            }

            public Builder onLimitReached(Consumer<? super CapturingWriter> callback) {
                this.limitReachedCallback = Objects.requireNonNull(callback);
                return this;
            }

            public Builder onError(BiConsumer<? super CapturingWriter, ? super IOException> callback) {
                this.errorCallback = Objects.requireNonNull(callback);
                return this;
            }

            public Config build() {
                return new Config(this);
            }
        }
    }
}

