/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import com.github.robtimus.io.stream.Messages;
import com.github.robtimus.io.stream.StreamUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Objects;
import java.util.Optional;

public final class HexInputStream
extends InputStream {
    private static final int READ_BUFFER_SIZE = 1024;
    private Reader source;
    private char[] readBuffer;
    private IOException exception;

    public HexInputStream(Reader source) {
        this.source = Objects.requireNonNull(source);
    }

    private void ensureOpen() throws IOException {
        if (this.source == null) {
            throw StreamUtils.streamClosedException();
        }
    }

    private void checkException() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    @Override
    public int read() throws IOException {
        int read;
        this.ensureOpen();
        this.checkException();
        if (this.readBuffer == null) {
            this.readBuffer = new char[1024];
        }
        if ((read = this.read(this.readBuffer, 2)) == -1) {
            return -1;
        }
        int high = this.convert(this.readBuffer[0]);
        int low = this.convert(this.readBuffer[1]);
        return HexInputStream.combine(high, low) & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        char[] cbuf;
        this.ensureOpen();
        this.checkException();
        int lenInHex = len * 2;
        if (lenInHex <= 1024) {
            if (this.readBuffer == null) {
                this.readBuffer = new char[1024];
            }
            cbuf = this.readBuffer;
        } else {
            cbuf = new char[lenInHex];
        }
        int read = this.read(cbuf, lenInHex);
        if (read == -1) {
            return -1;
        }
        int i = off;
        for (int j = 0; j < read; j += 2) {
            int high = this.convert(cbuf[j]);
            int low = this.convert(cbuf[j + 1]);
            b[i] = HexInputStream.combine(high, low);
            ++i;
        }
        return read / 2;
    }

    private int read(char[] cbuf, int lenInHex) throws IOException {
        int read = this.source.read(cbuf, 0, lenInHex);
        if (read == -1) {
            return -1;
        }
        while ((read & 1) == 1) {
            int n = this.source.read(cbuf, read, lenInHex - read);
            if (n == -1) {
                this.exception = new EOFException(Messages.hex.eof.get());
                throw this.exception;
            }
            read += n;
        }
        return read;
    }

    private int convert(char c) throws IOException {
        int value = Character.digit(c, 16);
        if (value == -1) {
            this.exception = new IOException(Messages.hex.invalidChar.get(Character.valueOf(c)));
            throw this.exception;
        }
        return value;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return 0;
    }

    @Override
    public void close() throws IOException {
        if (this.source != null) {
            this.source.close();
            this.source = null;
        }
    }

    public static byte[] decode(CharSequence hex) {
        return HexInputStream.decode(hex, 0, hex.length());
    }

    public static byte[] decode(CharSequence hex, int start, int end) {
        StreamUtils.checkStartAndEnd(hex, start, end);
        int length = end - start;
        if ((length & 1) == 1) {
            throw new IllegalArgumentException(Messages.hex.eof.get());
        }
        byte[] b = new byte[length / 2];
        int i = 0;
        for (int j = start; j < end; j += 2) {
            int high = HexInputStream.convert(hex, j);
            int low = HexInputStream.convert(hex, j + 1);
            b[i] = HexInputStream.combine(high, low);
            ++i;
        }
        return b;
    }

    private static int convert(CharSequence hex, int index) {
        char c = hex.charAt(index);
        int value = Character.digit(c, 16);
        if (value == -1) {
            throw new IllegalArgumentException(Messages.hex.invalidChar.get(Character.valueOf(c)));
        }
        return value;
    }

    public static Optional<byte[]> tryDecode(CharSequence hex) {
        return hex == null ? Optional.empty() : HexInputStream.tryDecode(hex, 0, hex.length());
    }

    public static Optional<byte[]> tryDecode(CharSequence hex, int start, int end) {
        if (hex == null) {
            return Optional.empty();
        }
        StreamUtils.checkStartAndEnd(hex, start, end);
        int length = end - start;
        if ((length & 1) == 1) {
            return Optional.empty();
        }
        byte[] b = new byte[length / 2];
        int i = 0;
        for (int j = start; j < end; j += 2) {
            int high = HexInputStream.tryConvert(hex, j);
            int low = HexInputStream.tryConvert(hex, j + 1);
            if (high == -1 || low == -1) {
                return Optional.empty();
            }
            b[i] = HexInputStream.combine(high, low);
            ++i;
        }
        return Optional.of(b);
    }

    private static int tryConvert(CharSequence hex, int index) {
        char c = hex.charAt(index);
        return Character.digit(c, 16);
    }

    private static byte combine(int high, int low) {
        return (byte)((high << 4 | low) & 0xFF);
    }
}

