/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import com.github.robtimus.io.stream.StreamUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

public final class HexOutputStream
extends OutputStream {
    private static final int WRITE_BUFFER_SIZE = 1024;
    private Writer output;
    private final boolean upperCase;
    private char[] writeBuffer;

    public HexOutputStream(Appendable destination) {
        this(destination, false);
    }

    public HexOutputStream(Appendable destination, boolean upperCase) {
        this.output = IOUtils.writer((Appendable)destination);
        this.upperCase = upperCase;
    }

    private void ensureOpen() throws IOException {
        if (this.output == null) {
            throw StreamUtils.streamClosedException();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureOpen();
        if (this.writeBuffer == null) {
            this.writeBuffer = new char[1024];
        }
        this.writeBuffer[0] = HexOutputStream.high(b, this.upperCase);
        this.writeBuffer[1] = HexOutputStream.low(b, this.upperCase);
        this.output.write(this.writeBuffer, 0, 2);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        char[] cbuf;
        this.ensureOpen();
        StreamUtils.checkOffsetAndLength(b, off, len);
        int lenInHex = len * 2;
        if (lenInHex <= 1024) {
            if (this.writeBuffer == null) {
                this.writeBuffer = new char[1024];
            }
            cbuf = this.writeBuffer;
        } else {
            cbuf = new char[lenInHex];
        }
        int i = off;
        int j = 0;
        int k = 0;
        while (j < len) {
            cbuf[k] = HexOutputStream.high(b[i], this.upperCase);
            cbuf[k + 1] = HexOutputStream.low(b[i], this.upperCase);
            ++i;
            ++j;
            k += 2;
        }
        this.output.write(cbuf, 0, lenInHex);
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
    }

    public static String encode(byte[] b) {
        return HexOutputStream.encode(b, 0, b.length);
    }

    public static String encode(byte[] b, int start, int end) {
        return HexOutputStream.encode(b, start, end, false);
    }

    public static String encode(byte[] b, boolean upperCase) {
        return HexOutputStream.encode(b, 0, b.length, upperCase);
    }

    public static String encode(byte[] b, int start, int end, boolean upperCase) {
        StreamUtils.checkStartAndEnd(b, start, end);
        char[] c = new char[(end - start) * 2];
        int i = start;
        int j = 0;
        while (i < end) {
            c[j] = HexOutputStream.high(b[i], upperCase);
            c[j + 1] = HexOutputStream.low(b[i], upperCase);
            ++i;
            j += 2;
        }
        return new String(c);
    }

    private static char high(int b, boolean upperCase) {
        int high = b >> 4 & 0xF;
        char c = Character.forDigit(high, 16);
        return upperCase ? Character.toUpperCase(c) : Character.toLowerCase(c);
    }

    private static char low(int b, boolean upperCase) {
        int low = b & 0xF;
        char c = Character.forDigit(low, 16);
        return upperCase ? Character.toUpperCase(c) : Character.toLowerCase(c);
    }
}

