/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import com.github.robtimus.io.stream.LimitExceededException;
import com.github.robtimus.io.stream.LimitExceededStrategy;
import com.github.robtimus.io.stream.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public final class LimitInputStream
extends InputStream {
    private final InputStream input;
    private final long limit;
    private final LimitExceededStrategy strategy;
    private long position;
    private long mark;

    public LimitInputStream(InputStream input, long limit) {
        this(input, limit, LimitExceededStrategy.DISCARD);
    }

    public LimitInputStream(InputStream input, long limit, LimitExceededStrategy strategy) {
        if (limit < 0L) {
            throw new IllegalArgumentException(limit + " < 0");
        }
        this.input = Objects.requireNonNull(input);
        this.limit = limit;
        this.strategy = Objects.requireNonNull(strategy);
        this.position = 0L;
        this.mark = 0L;
    }

    @Override
    public int read() throws IOException {
        if (this.position > this.limit) {
            return -1;
        }
        int c = this.input.read();
        if (c != -1) {
            ++this.position;
            this.checkLimitExceeded();
        }
        return this.position <= this.limit ? c : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        StreamUtils.checkOffsetAndLength(b, off, len);
        if (this.position > this.limit) {
            return -1;
        }
        int newLen = this.position == this.limit ? Math.min(len, 1) : (int)Math.min(this.limit - this.position, (long)len);
        int n = this.input.read(b, off, newLen);
        if (n != -1) {
            this.position += (long)n;
            this.checkLimitExceeded();
        }
        return this.position <= this.limit ? n : -1;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return this.input.skip(n);
        }
        if (this.position > this.limit) {
            return 0L;
        }
        long skipped = this.input.skip(Math.min(this.limit - this.position + 1L, n));
        this.position += skipped;
        this.checkLimitExceeded();
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.position < this.limit ? (int)Math.min(this.limit - this.position, (long)this.input.available()) : 0;
    }

    @Override
    public boolean markSupported() {
        return this.input.markSupported();
    }

    @Override
    public synchronized void mark(int readAheadLimit) {
        this.input.mark(readAheadLimit);
        this.mark = this.position;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.input.reset();
        this.position = this.mark;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    private void checkLimitExceeded() throws IOException {
        if (this.position > this.limit && this.strategy.throwException()) {
            throw new LimitExceededException(this.limit);
        }
    }
}

