/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import com.github.robtimus.io.stream.LimitExceededException;
import com.github.robtimus.io.stream.LimitExceededStrategy;
import com.github.robtimus.io.stream.StreamUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public final class LimitOutputStream
extends OutputStream {
    private final OutputStream output;
    private final long limit;
    private final LimitExceededStrategy strategy;
    private long position;

    public LimitOutputStream(OutputStream output, long limit) {
        this(output, limit, LimitExceededStrategy.DISCARD);
    }

    public LimitOutputStream(OutputStream output, long limit, LimitExceededStrategy strategy) {
        if (limit < 0L) {
            throw new IllegalArgumentException(limit + " < 0");
        }
        this.output = Objects.requireNonNull(output);
        this.limit = limit;
        this.strategy = Objects.requireNonNull(strategy);
        this.position = 0L;
    }

    @Override
    public void write(int c) throws IOException {
        if (this.position >= this.limit) {
            this.handleLimitExceeded();
            return;
        }
        this.output.write(c);
        ++this.position;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        StreamUtils.checkOffsetAndLength(b, off, len);
        if (this.position >= this.limit) {
            this.handleLimitExceeded();
            return;
        }
        int allowedLen = (int)Math.min(this.limit - this.position, (long)len);
        this.output.write(b, off, allowedLen);
        this.position += (long)allowedLen;
        if (allowedLen < len) {
            this.handleLimitExceeded();
        }
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }

    private void handleLimitExceeded() throws IOException {
        if (this.strategy.throwException()) {
            throw new LimitExceededException(this.limit);
        }
    }
}

