/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import com.github.robtimus.io.stream.LimitExceededException;
import com.github.robtimus.io.stream.LimitExceededStrategy;
import com.github.robtimus.io.stream.StreamUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;

public final class LimitReader
extends Reader {
    private final Reader reader;
    private final long limit;
    private final LimitExceededStrategy strategy;
    private long position;
    private long mark;

    public LimitReader(Reader reader, long limit) {
        this(reader, limit, LimitExceededStrategy.DISCARD);
    }

    public LimitReader(Reader reader, long limit, LimitExceededStrategy strategy) {
        if (limit < 0L) {
            throw new IllegalArgumentException(limit + " < 0");
        }
        this.reader = Objects.requireNonNull(reader);
        this.limit = limit;
        this.strategy = Objects.requireNonNull(strategy);
        this.position = 0L;
        this.mark = 0L;
    }

    @Override
    public int read() throws IOException {
        if (this.position > this.limit) {
            return -1;
        }
        int c = this.reader.read();
        if (c != -1) {
            ++this.position;
            this.checkLimitExceeded();
        }
        return this.position <= this.limit ? c : -1;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        StreamUtils.checkOffsetAndLength(cbuf, off, len);
        if (this.position > this.limit) {
            return -1;
        }
        int newLen = this.position == this.limit ? Math.min(len, 1) : (int)Math.min(this.limit - this.position, (long)len);
        int n = this.reader.read(cbuf, off, newLen);
        if (n != -1) {
            this.position += (long)n;
            this.checkLimitExceeded();
        }
        return this.position <= this.limit ? n : -1;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return this.reader.skip(n);
        }
        if (this.position > this.limit) {
            return 0L;
        }
        long skipped = this.reader.skip(Math.min(this.limit - this.position + 1L, n));
        this.position += skipped;
        this.checkLimitExceeded();
        return skipped;
    }

    @Override
    public boolean ready() throws IOException {
        return this.position < this.limit && this.reader.ready();
    }

    @Override
    public boolean markSupported() {
        return this.reader.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.reader.mark(readAheadLimit);
        this.mark = this.position;
    }

    @Override
    public void reset() throws IOException {
        this.reader.reset();
        this.position = this.mark;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private void checkLimitExceeded() throws IOException {
        if (this.position > this.limit && this.strategy.throwException()) {
            throw new LimitExceededException(this.limit);
        }
    }
}

