/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import com.github.robtimus.io.stream.LimitExceededException;
import com.github.robtimus.io.stream.LimitExceededStrategy;
import com.github.robtimus.io.stream.StreamUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;

public final class LimitWriter
extends Writer {
    private final Writer writer;
    private final long limit;
    private final LimitExceededStrategy strategy;
    private long position;

    public LimitWriter(Writer writer, long limit) {
        this(writer, limit, LimitExceededStrategy.DISCARD);
    }

    public LimitWriter(Writer writer, long limit, LimitExceededStrategy strategy) {
        if (limit < 0L) {
            throw new IllegalArgumentException(limit + " < 0");
        }
        this.writer = Objects.requireNonNull(writer);
        this.limit = limit;
        this.strategy = Objects.requireNonNull(strategy);
        this.position = 0L;
    }

    @Override
    public void write(int c) throws IOException {
        if (this.position >= this.limit) {
            this.handleLimitExceeded();
            return;
        }
        this.writer.write(c);
        ++this.position;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        StreamUtils.checkOffsetAndLength(cbuf, off, len);
        if (this.position >= this.limit) {
            this.handleLimitExceeded();
            return;
        }
        int allowedLen = (int)Math.min(this.limit - this.position, (long)len);
        this.writer.write(cbuf, off, allowedLen);
        this.position += (long)allowedLen;
        if (allowedLen < len) {
            this.handleLimitExceeded();
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        StreamUtils.checkOffsetAndLength(str, off, len);
        if (this.position >= this.limit) {
            this.handleLimitExceeded();
            return;
        }
        int allowedLen = (int)Math.min(this.limit - this.position, (long)len);
        this.writer.write(str, off, allowedLen);
        this.position += (long)allowedLen;
        if (allowedLen < len) {
            this.handleLimitExceeded();
        }
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        CharSequence cs = csq != null ? csq : "null";
        return this.append(cs, 0, cs.length());
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        CharSequence cs = csq != null ? csq : "null";
        StreamUtils.checkStartAndEnd(cs, start, end);
        if (this.position >= this.limit) {
            this.handleLimitExceeded();
            return this;
        }
        int allowedEnd = (int)Math.min((long)start + this.limit - this.position, (long)end);
        this.writer.append(cs, start, allowedEnd);
        this.position += (long)(allowedEnd - start);
        if (allowedEnd < end) {
            this.handleLimitExceeded();
        }
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        if (this.position >= this.limit) {
            this.handleLimitExceeded();
            return this;
        }
        this.writer.append(c);
        ++this.position;
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private void handleLimitExceeded() throws IOException {
        if (this.strategy.throwException()) {
            throw new LimitExceededException(this.limit);
        }
    }
}

