/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

final class Messages {
    private static final Map<Locale, ResourceBundle> BUNDLES = new HashMap<Locale, ResourceBundle>();
    static final Array_ array = new Array_();
    static final CharSequence_ charSequence = new CharSequence_();
    static final Stream_ stream = new Stream_();
    static final Pipe_ pipe = new Pipe_();
    static final Ascii_ ascii = new Ascii_();
    static final Hex_ hex = new Hex_();
    static final LimitExceededException_ LimitExceededException = new LimitExceededException_();
    static final MultiLineReader_ MultiLineReader = new MultiLineReader_();
    static final RandomReader_ RandomReader = new RandomReader_();

    private Messages() {
        throw new IllegalStateException("cannot create instances of " + this.getClass().getName());
    }

    private static synchronized ResourceBundle getResourceBundle(Locale locale) {
        Locale l = Messages.nonNull(locale);
        ResourceBundle bundle = BUNDLES.get(l);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("com.github.robtimus.io.stream.io-streams", l);
            BUNDLES.put(l, bundle);
        }
        return bundle;
    }

    private static String getString(Locale locale, String key) {
        ResourceBundle bundle = Messages.getResourceBundle(locale);
        return bundle.getString(key);
    }

    private static Locale nonNull(Locale locale) {
        return locale != null ? locale : Locale.getDefault(Locale.Category.FORMAT);
    }

    static final class RandomReader_ {
        final EmptyAlphabet_ emptyAlphabet = new EmptyAlphabet_();

        private RandomReader_() {
        }

        static final class EmptyAlphabet_ {
            private EmptyAlphabet_() {
            }

            String get() {
                return this.get(null);
            }

            String get(Locale locale) {
                Locale l = Messages.nonNull(locale);
                return Messages.getString(l, "RandomReader.emptyAlphabet");
            }
        }
    }

    static final class MultiLineReader_ {
        final IteratorAlreadyReturned_ iteratorAlreadyReturned = new IteratorAlreadyReturned_();

        private MultiLineReader_() {
        }

        static final class IteratorAlreadyReturned_ {
            private IteratorAlreadyReturned_() {
            }

            String get() {
                return this.get(null);
            }

            String get(Locale locale) {
                Locale l = Messages.nonNull(locale);
                return Messages.getString(l, "MultiLineReader.iteratorAlreadyReturned");
            }
        }
    }

    static final class LimitExceededException_ {
        final Init_ init = new Init_();

        private LimitExceededException_() {
        }

        static final class Init_ {
            private Init_() {
            }

            String get(Object arg) {
                return this.get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = Messages.nonNull(locale);
                String s = Messages.getString(l, "LimitExceededException.init");
                return String.format(l, s, arg);
            }
        }
    }

    static final class Hex_ {
        final Eof_ eof = new Eof_();
        final InvalidChar_ invalidChar = new InvalidChar_();

        private Hex_() {
        }

        static final class InvalidChar_ {
            private InvalidChar_() {
            }

            String get(Object arg) {
                return this.get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = Messages.nonNull(locale);
                String s = Messages.getString(l, "hex.invalidChar");
                return String.format(l, s, arg);
            }
        }

        static final class Eof_ {
            private Eof_() {
            }

            String get() {
                return this.get(null);
            }

            String get(Locale locale) {
                Locale l = Messages.nonNull(locale);
                return Messages.getString(l, "hex.eof");
            }
        }
    }

    static final class Ascii_ {
        final InvalidByte_ invalidByte = new InvalidByte_();
        final InvalidChar_ invalidChar = new InvalidChar_();

        private Ascii_() {
        }

        static final class InvalidChar_ {
            private InvalidChar_() {
            }

            String get(Object arg) {
                return this.get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = Messages.nonNull(locale);
                String s = Messages.getString(l, "ascii.invalidChar");
                return String.format(l, s, arg);
            }
        }

        static final class InvalidByte_ {
            private InvalidByte_() {
            }

            String get(Object arg) {
                return this.get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = Messages.nonNull(locale);
                String s = Messages.getString(l, "ascii.invalidByte");
                return String.format(l, s, arg);
            }
        }
    }

    static final class Pipe_ {
        final ReaderDied_ readerDied = new ReaderDied_();
        final WriterDied_ writerDied = new WriterDied_();

        private Pipe_() {
        }

        static final class WriterDied_ {
            private WriterDied_() {
            }

            String get() {
                return this.get(null);
            }

            String get(Locale locale) {
                Locale l = Messages.nonNull(locale);
                return Messages.getString(l, "pipe.writerDied");
            }
        }

        static final class ReaderDied_ {
            private ReaderDied_() {
            }

            String get() {
                return this.get(null);
            }

            String get(Locale locale) {
                Locale l = Messages.nonNull(locale);
                return Messages.getString(l, "pipe.readerDied");
            }
        }
    }

    static final class Stream_ {
        final Closed_ closed = new Closed_();

        private Stream_() {
        }

        static final class Closed_ {
            private Closed_() {
            }

            String get() {
                return this.get(null);
            }

            String get(Locale locale) {
                Locale l = Messages.nonNull(locale);
                return Messages.getString(l, "stream.closed");
            }
        }
    }

    static final class CharSequence_ {
        final InvalidIndex_ invalidIndex = new InvalidIndex_();
        final InvalidOffsetOrLength_ invalidOffsetOrLength = new InvalidOffsetOrLength_();
        final InvalidStartOrEnd_ invalidStartOrEnd = new InvalidStartOrEnd_();

        private CharSequence_() {
        }

        static final class InvalidStartOrEnd_ {
            private InvalidStartOrEnd_() {
            }

            String get(Object arg1, Object arg2, Object arg3) {
                return this.get(null, arg1, arg2, arg3);
            }

            String get(Locale locale, Object arg1, Object arg2, Object arg3) {
                Locale l = Messages.nonNull(locale);
                String s = Messages.getString(l, "charSequence.invalidStartOrEnd");
                return String.format(l, s, arg1, arg2, arg3);
            }
        }

        static final class InvalidOffsetOrLength_ {
            private InvalidOffsetOrLength_() {
            }

            String get(Object arg1, Object arg2, Object arg3) {
                return this.get(null, arg1, arg2, arg3);
            }

            String get(Locale locale, Object arg1, Object arg2, Object arg3) {
                Locale l = Messages.nonNull(locale);
                String s = Messages.getString(l, "charSequence.invalidOffsetOrLength");
                return String.format(l, s, arg1, arg2, arg3);
            }
        }

        static final class InvalidIndex_ {
            private InvalidIndex_() {
            }

            String get(Object arg1, Object arg2) {
                return this.get(null, arg1, arg2);
            }

            String get(Locale locale, Object arg1, Object arg2) {
                Locale l = Messages.nonNull(locale);
                String s = Messages.getString(l, "charSequence.invalidIndex");
                return String.format(l, s, arg1, arg2);
            }
        }
    }

    static final class Array_ {
        final InvalidOffsetOrLength_ invalidOffsetOrLength = new InvalidOffsetOrLength_();
        final InvalidStartOrEnd_ invalidStartOrEnd = new InvalidStartOrEnd_();

        private Array_() {
        }

        static final class InvalidStartOrEnd_ {
            private InvalidStartOrEnd_() {
            }

            String get(Object arg1, Object arg2, Object arg3) {
                return this.get(null, arg1, arg2, arg3);
            }

            String get(Locale locale, Object arg1, Object arg2, Object arg3) {
                Locale l = Messages.nonNull(locale);
                String s = Messages.getString(l, "array.invalidStartOrEnd");
                return String.format(l, s, arg1, arg2, arg3);
            }
        }

        static final class InvalidOffsetOrLength_ {
            private InvalidOffsetOrLength_() {
            }

            String get(Object arg1, Object arg2, Object arg3) {
                return this.get(null, arg1, arg2, arg3);
            }

            String get(Locale locale, Object arg1, Object arg2, Object arg3) {
                Locale l = Messages.nonNull(locale);
                String s = Messages.getString(l, "array.invalidOffsetOrLength");
                return String.format(l, s, arg1, arg2, arg3);
            }
        }
    }
}

