/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import com.github.robtimus.io.stream.Messages;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;

public final class MultiLineReader
implements Iterable<Entry>,
Closeable {
    private final BufferedReader reader;
    private final Predicate<? super String> newEntryStart;
    private boolean returnedIterator = false;

    public MultiLineReader(Reader reader, Pattern newEntryStart) {
        this(reader, newEntryStart.asPredicate());
    }

    public MultiLineReader(Reader reader, Predicate<? super String> newEntryStart) {
        this.reader = IOUtils.buffer((Reader)Objects.requireNonNull(reader));
        this.newEntryStart = Objects.requireNonNull(newEntryStart);
    }

    @Override
    public Iterator<Entry> iterator() {
        if (this.returnedIterator) {
            throw new IllegalStateException(Messages.MultiLineReader.iteratorAlreadyReturned.get());
        }
        this.returnedIterator = true;
        return new EntryIterator();
    }

    @Override
    public Spliterator<Entry> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 1296);
    }

    public Stream<Entry> entries() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private static final class EntrySpliterator
    implements Spliterator<String> {
        private final Spliterator<String> spliterator;

        private EntrySpliterator(Spliterator<String> spliterator) {
            this.spliterator = spliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super String> action) {
            return this.spliterator.tryAdvance(action);
        }

        @Override
        public void forEachRemaining(Consumer<? super String> action) {
            this.spliterator.forEachRemaining(action);
        }

        @Override
        public Spliterator<String> trySplit() {
            Spliterator<String> split = this.spliterator.trySplit();
            return split != null ? new EntrySpliterator(split) : null;
        }

        @Override
        public long estimateSize() {
            return this.spliterator.estimateSize();
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.spliterator.getExactSizeIfKnown();
        }

        @Override
        public int characteristics() {
            return this.spliterator.characteristics() | 0x100 | 0x400;
        }

        @Override
        public Comparator<? super String> getComparator() {
            return this.spliterator.getComparator();
        }
    }

    private final class EntryIterator
    implements Iterator<Entry> {
        private Entry nextEntry;
        private String lastLine;
        private boolean initialized;

        private EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry == null) {
                try {
                    this.nextEntry = this.readNextEntry();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return this.nextEntry != null;
        }

        @Override
        public Entry next() {
            if (this.hasNext()) {
                Entry next = this.nextEntry;
                this.nextEntry = null;
                return next;
            }
            throw new NoSuchElementException();
        }

        private Entry readNextEntry() throws IOException {
            if (this.lastLine == null) {
                if (this.initialized) {
                    return null;
                }
                this.lastLine = MultiLineReader.this.reader.readLine();
                this.initialized = true;
                if (this.lastLine == null) {
                    return null;
                }
            }
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(this.lastLine);
            while ((this.lastLine = MultiLineReader.this.reader.readLine()) != null && !MultiLineReader.this.newEntryStart.test(this.lastLine)) {
                lines.add(this.lastLine);
            }
            return new Entry(lines);
        }
    }

    public static final class Entry
    implements Iterable<String> {
        private final List<String> lines;

        Entry(List<String> lines) {
            this.lines = Collections.unmodifiableList(lines);
        }

        public List<String> lines() {
            return this.lines;
        }

        @Override
        public Iterator<String> iterator() {
            return this.lines.iterator();
        }

        @Override
        public Spliterator<String> spliterator() {
            return new EntrySpliterator(this.lines.spliterator());
        }

        public Stream<String> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        public void forEach(Consumer<? super String> action) {
            this.lines.forEach(action);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Entry other = (Entry)o;
            return this.lines.equals(other.lines);
        }

        public int hashCode() {
            return this.lines.hashCode();
        }

        public String toString() {
            return String.join((CharSequence)System.getProperty("line.separator"), this.lines);
        }
    }
}

