/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import com.github.robtimus.io.stream.TextPipe;
import java.io.IOException;
import java.io.Writer;

public final class PipeWriter
extends Writer {
    private final TextPipe pipe;

    PipeWriter(TextPipe pipe) {
        this.pipe = pipe;
    }

    public TextPipe pipe() {
        return this.pipe;
    }

    @Override
    public void write(int b) throws IOException {
        this.pipe.write(b);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.pipe.write(cbuf, off, len);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.pipe.write(str, off, len);
    }

    @Override
    public PipeWriter append(CharSequence csq) throws IOException {
        this.pipe.append(csq);
        return this;
    }

    @Override
    public PipeWriter append(CharSequence csq, int start, int end) throws IOException {
        this.pipe.append(csq, start, end);
        return this;
    }

    @Override
    public PipeWriter append(char c) throws IOException {
        this.write(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.pipe.flush();
    }

    @Override
    public void close() {
        this.pipe.closeOutput();
    }

    public void close(IOException error) {
        this.pipe.closeOutput(error);
    }
}

