/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import com.github.robtimus.io.stream.StreamUtils;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public final class RandomInputStream
extends InputStream {
    private final Random random;
    private final ToIntFunction<Random> byteGenerator;
    private final long limit;
    private long index;
    private long mark;

    private RandomInputStream(Builder builder) {
        this.random = builder.random != null ? builder.random : new SecureRandom();
        this.byteGenerator = builder.byteGenerator;
        this.limit = builder.limitGenerator != null ? builder.limitGenerator.applyAsLong(this.random) : builder.limit;
        this.index = 0L;
        this.mark = 0L;
    }

    @Override
    public int read() {
        if (this.limit >= 0L && this.index >= this.limit) {
            return -1;
        }
        ++this.index;
        return this.nextByte() & 0xFF;
    }

    @Override
    public int read(byte[] cbuf) {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        StreamUtils.checkOffsetAndLength(b, off, len);
        if (this.limit >= 0L && this.index >= this.limit) {
            return -1;
        }
        int n = this.limit >= 0L ? (int)Math.min(this.limit - this.index, (long)len) : len;
        int i = off;
        for (int j = 0; j < n; ++j) {
            b[i] = this.nextByte();
            ++i;
        }
        this.index += (long)n;
        return n;
    }

    @Override
    public long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        if (this.limit < 0L) {
            this.index += n;
            return n;
        }
        if (this.index >= this.limit) {
            return 0L;
        }
        long s = Math.min(this.limit - this.index, n);
        this.index += s;
        return s;
    }

    @Override
    public int available() {
        if (this.limit < 0L) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.max(0L, this.limit - this.index);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readAheadLimit) {
        this.mark = this.index;
    }

    @Override
    public synchronized void reset() {
        this.index = this.mark;
    }

    @Override
    public void close() {
        this.index = 0L;
        this.mark = 0L;
    }

    private byte nextByte() {
        return (byte)this.byteGenerator.applyAsInt(this.random);
    }

    public static Builder usingAllBytes() {
        return RandomInputStream.usingGenerator(r -> r.nextInt(128));
    }

    public static Builder usingRange(int start, int end) {
        int s = start & 0xFF;
        int e = end & 0xFF;
        if (s > e) {
            throw new IllegalArgumentException(s + " > " + e);
        }
        return RandomInputStream.usingGenerator(r -> s + r.nextInt(e - s + 1));
    }

    public static Builder usingRangeFrom(int start) {
        return RandomInputStream.usingRange(start, 255);
    }

    public static Builder usingRangeUntil(int end) {
        return RandomInputStream.usingRange(0, end);
    }

    public static Builder usingGenerator(ToIntFunction<Random> generator) {
        Objects.requireNonNull(generator);
        return new Builder(generator);
    }

    public static final class Builder {
        private final ToIntFunction<Random> byteGenerator;
        private Random random;
        private long limit = -1L;
        private ToLongFunction<Random> limitGenerator = null;

        private Builder(ToIntFunction<Random> byteGenerator) {
            this.byteGenerator = byteGenerator;
        }

        public Builder withRandom(Random random) {
            this.random = Objects.requireNonNull(random);
            return this;
        }

        public Builder withLimit(long limit) {
            this.limit = Math.max(limit, -1L);
            this.limitGenerator = null;
            return this;
        }

        public Builder withRandomLimit(int min, int max) {
            if (min < 0) {
                throw new IllegalArgumentException(min + " < 0");
            }
            if (max <= min) {
                throw new IllegalArgumentException(max + " <= " + min);
            }
            this.limitGenerator = r -> min + r.nextInt(max - min);
            return this;
        }

        public <R> R transform(Function<? super Builder, ? extends R> f) {
            return f.apply(this);
        }

        public RandomInputStream build() {
            return new RandomInputStream(this);
        }
    }
}

