/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import com.github.robtimus.io.stream.Messages;
import com.github.robtimus.io.stream.StreamUtils;
import java.io.Reader;
import java.nio.CharBuffer;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public final class RandomReader
extends Reader {
    private final Random random;
    private final ToIntFunction<Random> characterGenerator;
    private final long limit;
    private long index;
    private long mark;

    private RandomReader(Builder builder) {
        this.random = builder.random != null ? builder.random : new SecureRandom();
        this.characterGenerator = builder.characterGenerator;
        this.limit = builder.limitGenerator != null ? builder.limitGenerator.applyAsLong(this.random) : builder.limit;
        this.index = 0L;
        this.mark = 0L;
    }

    @Override
    public int read() {
        if (this.limit >= 0L && this.index >= this.limit) {
            return -1;
        }
        ++this.index;
        return this.nextChar();
    }

    @Override
    public int read(char[] cbuf) {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        StreamUtils.checkOffsetAndLength(cbuf, off, len);
        if (this.limit >= 0L && this.index >= this.limit) {
            return -1;
        }
        int n = this.limit >= 0L ? (int)Math.min(this.limit - this.index, (long)len) : len;
        int i = off;
        for (int j = 0; j < n; ++j) {
            cbuf[i] = this.nextChar();
            ++i;
        }
        this.index += (long)n;
        return n;
    }

    @Override
    public int read(CharBuffer target) {
        Objects.requireNonNull(target);
        if (this.limit >= 0L && this.index >= this.limit) {
            return -1;
        }
        int n = this.limit >= 0L ? (int)Math.min(this.limit - this.index, (long)target.remaining()) : target.remaining();
        for (int i = 0; i < n; ++i) {
            target.put(this.nextChar());
        }
        this.index += (long)n;
        return n;
    }

    @Override
    public long skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(n + " < 0");
        }
        if (this.limit < 0L) {
            this.index += n;
            return n;
        }
        if (this.index >= this.limit) {
            return 0L;
        }
        long s = Math.min(this.limit - this.index, n);
        this.index += s;
        return s;
    }

    @Override
    public boolean ready() {
        return this.limit < 0L || this.index < this.limit;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.index;
    }

    @Override
    public void reset() {
        this.index = this.mark;
    }

    @Override
    public void close() {
        this.index = 0L;
        this.mark = 0L;
    }

    private char nextChar() {
        return (char)this.characterGenerator.applyAsInt(this.random);
    }

    public static Builder usingAllCharacters() {
        return RandomReader.usingGenerator(r -> r.nextInt(65536));
    }

    public static Builder usingRange(char start, char end) {
        if (start > end) {
            throw new IllegalArgumentException(start + " > " + end);
        }
        return RandomReader.usingGenerator(r -> start + r.nextInt(end - start + 1));
    }

    public static Builder usingAlphabet(String alphabet) {
        Objects.requireNonNull(alphabet);
        if (alphabet.isEmpty()) {
            throw new IllegalArgumentException(Messages.RandomReader.emptyAlphabet.get());
        }
        return RandomReader.usingGenerator(r -> alphabet.charAt(r.nextInt(alphabet.length())));
    }

    public static Builder usingHex() {
        return RandomReader.usingHex(false);
    }

    public static Builder usingHex(boolean upperCase) {
        return RandomReader.usingGenerator(r -> RandomReader.randomHex(r, upperCase));
    }

    private static char randomHex(Random r, boolean upperCase) {
        char c = Character.forDigit(r.nextInt(16), 16);
        return upperCase ? Character.toUpperCase(c) : Character.toLowerCase(c);
    }

    public static Builder usingDigits() {
        return RandomReader.usingGenerator(r -> 48 + r.nextInt(10));
    }

    public static Builder usingGenerator(ToIntFunction<Random> generator) {
        Objects.requireNonNull(generator);
        return new Builder(generator);
    }

    public static final class Builder {
        private final ToIntFunction<Random> characterGenerator;
        private Random random;
        private long limit = -1L;
        private ToLongFunction<Random> limitGenerator = null;

        private Builder(ToIntFunction<Random> characterGenerator) {
            this.characterGenerator = characterGenerator;
        }

        public Builder withRandom(Random random) {
            this.random = Objects.requireNonNull(random);
            return this;
        }

        public Builder withLimit(long limit) {
            this.limit = Math.max(limit, -1L);
            this.limitGenerator = null;
            return this;
        }

        public Builder withRandomLimit(int min, int max) {
            if (min < 0) {
                throw new IllegalArgumentException(min + " < 0");
            }
            if (max <= min) {
                throw new IllegalArgumentException(max + " <= " + min);
            }
            this.limitGenerator = r -> min + r.nextInt(max - min);
            return this;
        }

        public <R> R transform(Function<? super Builder, ? extends R> f) {
            return f.apply(this);
        }

        public RandomReader build() {
            return new RandomReader(this);
        }
    }
}

