/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.io.stream;

import com.github.robtimus.io.stream.Messages;
import com.github.robtimus.io.stream.PipeReader;
import com.github.robtimus.io.stream.PipeWriter;
import com.github.robtimus.io.stream.StreamUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class TextPipe {
    private static final long AWAIT_TIME = TimeUnit.SECONDS.toNanos(1L);
    private final PipeReader input;
    private final PipeWriter output;
    private final char[] single = new char[1];
    private Data data;
    private ArrayData arrayData;
    private CharSequenceData charSequenceData;
    private int start;
    private int end;
    private final Lock lock = new ReentrantLock();
    private final Condition closedOrNotEmpty = this.lock.newCondition();
    private final Condition closedOrEmpty = this.lock.newCondition();
    private boolean closed = false;
    private IOException readError = null;
    private IOException writeError = null;
    private Thread readThread;
    private Thread writeThread;

    public TextPipe() {
        this.input = new PipeReader(this);
        this.output = new PipeWriter(this);
    }

    public PipeReader input() {
        return this.input;
    }

    public PipeWriter output() {
        return this.output;
    }

    public boolean closed() {
        this.lock.lock();
        try {
            boolean bl = this.closed;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    int read() throws IOException {
        this.lock.lock();
        try {
            this.readThread = Thread.currentThread();
            while (!this.closed && this.start == this.end && !this.writerDied()) {
                this.await(this.closedOrNotEmpty);
            }
            this.throwWriteError();
            if (this.start < this.end) {
                char c = this.data.charAt(this.start++);
                this.checkEmpty();
                int n = c & 0xFF;
                return n;
            }
            if (this.closed) {
                int n = -1;
                return n;
            }
            throw this.writerDiedException();
        }
        finally {
            this.lock.unlock();
        }
    }

    int read(char[] cbuf, int off, int len) throws IOException {
        StreamUtils.checkOffsetAndLength(cbuf, off, len);
        if (len == 0) {
            return 0;
        }
        this.lock.lock();
        try {
            this.readThread = Thread.currentThread();
            while (!this.closed && this.start == this.end && !this.writerDied()) {
                this.await(this.closedOrNotEmpty);
            }
            this.throwWriteError();
            if (this.start < this.end) {
                int result = Math.min(len, this.end - this.start);
                this.data.copyTo(this.start, cbuf, off, result);
                this.start += result;
                this.checkEmpty();
                int n = result;
                return n;
            }
            if (this.closed) {
                int n = -1;
                return n;
            }
            throw this.writerDiedException();
        }
        finally {
            this.lock.unlock();
        }
    }

    long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException(n + " < 0");
        }
        if (n == 0L) {
            return 0L;
        }
        this.lock.lock();
        try {
            this.readThread = Thread.currentThread();
            while (!this.closed && this.start == this.end && !this.writerDied()) {
                this.await(this.closedOrNotEmpty);
            }
            this.throwWriteError();
            if (this.start < this.end) {
                long result = Math.min(n, (long)this.end - (long)this.start);
                this.start = (int)((long)this.start + result);
                this.checkEmpty();
                long l = result;
                return l;
            }
            if (this.closed) {
                long l = 0L;
                return l;
            }
            throw this.writerDiedException();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkEmpty() {
        if (this.start == this.end) {
            this.data = null;
            this.closedOrEmpty.signalAll();
        }
    }

    boolean ready() throws IOException {
        this.lock.lock();
        try {
            this.readThread = Thread.currentThread();
            this.throwWriteError();
            boolean bl = this.start < this.end;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    void closeInput() {
        this.lock.lock();
        try {
            this.data = null;
            this.start = 0;
            this.end = 0;
            this.closed = true;
            this.closedOrNotEmpty.signalAll();
            this.closedOrEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    void closeInput(IOException error) {
        this.lock.lock();
        try {
            this.data = null;
            this.start = 0;
            this.end = 0;
            this.closed = true;
            this.readError = error;
            this.closedOrNotEmpty.signalAll();
            this.closedOrEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void throwWriteError() throws IOException {
        if (this.writeError != null) {
            throw this.writeError;
        }
    }

    private boolean writerDied() {
        return this.writeThread != null && !this.writeThread.isAlive();
    }

    private IOException writerDiedException() {
        return new IOException(Messages.pipe.writerDied.get());
    }

    void write(int c) throws IOException {
        this.lock.lock();
        try {
            this.writeThread = Thread.currentThread();
            while (!this.closed && this.start < this.end && !this.readerDied()) {
                this.await(this.closedOrEmpty);
            }
            this.throwReadError();
            this.throwIfClosed();
            if (this.start == this.end) {
                this.single[0] = (char)c;
                this.data = this.arrayData(this.single);
                this.start = 0;
                this.end = 1;
                this.closedOrNotEmpty.signalAll();
            }
            this.awaitDataRead();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(char[] cbuf, int off, int len) throws IOException {
        StreamUtils.checkOffsetAndLength(cbuf, off, len);
        this.lock.lock();
        try {
            this.writeThread = Thread.currentThread();
            while (!this.closed && this.start < this.end && !this.readerDied()) {
                this.await(this.closedOrEmpty);
            }
            this.throwReadError();
            this.throwIfClosed();
            if (this.start == this.end) {
                this.data = this.arrayData(cbuf);
                this.start = off;
                this.end = off + len;
                this.closedOrNotEmpty.signalAll();
            }
            this.awaitDataRead();
        }
        finally {
            this.lock.unlock();
        }
    }

    private Data arrayData(char[] array) {
        if (this.arrayData == null) {
            this.arrayData = new ArrayData();
        }
        ArrayData.access$102(this.arrayData, array);
        return this.arrayData;
    }

    void write(String str, int off, int len) throws IOException {
        StreamUtils.checkOffsetAndLength(str, off, len);
        this.writeChars(str, off, len);
    }

    void append(CharSequence csq) throws IOException {
        CharSequence cs = csq == null ? "null" : csq;
        this.writeChars(cs, 0, cs.length());
    }

    void append(CharSequence csq, int start, int end) throws IOException {
        CharSequence cs = csq == null ? "null" : csq;
        StreamUtils.checkStartAndEnd(cs, start, end);
        this.writeChars(cs, start, end - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChars(CharSequence csq, int off, int len) throws IOException {
        this.lock.lock();
        try {
            this.writeThread = Thread.currentThread();
            while (!this.closed && this.start < this.end && !this.readerDied()) {
                this.await(this.closedOrEmpty);
            }
            this.throwReadError();
            this.throwIfClosed();
            if (this.start == this.end) {
                this.data = this.charSequenceData(csq);
                this.start = off;
                this.end = off + len;
                this.closedOrNotEmpty.signalAll();
            }
            this.awaitDataRead();
        }
        finally {
            this.lock.unlock();
        }
    }

    private Data charSequenceData(CharSequence csq) {
        if (this.charSequenceData == null) {
            this.charSequenceData = new CharSequenceData();
        }
        this.charSequenceData.charSequence = csq;
        return this.charSequenceData;
    }

    private void awaitDataRead() throws IOException {
        while (!this.closed && this.start < this.end && !this.readerDied()) {
            this.await(this.closedOrEmpty);
        }
        this.throwReadError();
        this.throwIfClosed();
        if (this.start < this.end) {
            throw this.readerDiedException();
        }
    }

    void flush() throws IOException {
        this.lock.lock();
        try {
            this.writeThread = Thread.currentThread();
            this.throwReadError();
            this.throwIfClosed();
            this.throwIfReaderDied();
        }
        finally {
            this.lock.unlock();
        }
    }

    void closeOutput() {
        this.lock.lock();
        try {
            this.closed = true;
            this.closedOrNotEmpty.signalAll();
            this.closedOrEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    void closeOutput(IOException error) {
        this.lock.lock();
        try {
            this.closed = true;
            this.writeError = error;
            this.closedOrNotEmpty.signalAll();
            this.closedOrEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void throwReadError() throws IOException {
        if (this.readError != null) {
            throw this.readError;
        }
    }

    private void throwIfClosed() throws IOException {
        if (this.closed) {
            throw new IOException(Messages.stream.closed.get());
        }
    }

    private void throwIfReaderDied() throws IOException {
        if (this.readerDied()) {
            throw this.readerDiedException();
        }
    }

    private boolean readerDied() {
        return this.readThread != null && !this.readThread.isAlive();
    }

    private IOException readerDiedException() {
        return new IOException(Messages.pipe.readerDied.get());
    }

    private void await(Condition condition) throws IOException {
        try {
            condition.awaitNanos(AWAIT_TIME);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            InterruptedIOException exception = new InterruptedIOException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    private static class CharSequenceData
    implements Data {
        private CharSequence charSequence;

        private CharSequenceData() {
        }

        @Override
        public char charAt(int index) {
            return this.charSequence.charAt(index);
        }

        @Override
        public void copyTo(int start, char[] cbuf, int off, int len) {
            if (this.charSequence instanceof String) {
                ((String)this.charSequence).getChars(start, start + len, cbuf, off);
            } else if (this.charSequence instanceof StringBuilder) {
                ((StringBuilder)this.charSequence).getChars(start, start + len, cbuf, off);
            } else if (this.charSequence instanceof StringBuffer) {
                ((StringBuffer)this.charSequence).getChars(start, start + len, cbuf, off);
            } else {
                int i = start;
                int j = off;
                for (int k = 0; k < len; ++k) {
                    cbuf[j] = this.charSequence.charAt(i);
                    ++i;
                    ++j;
                }
            }
        }
    }

    private static class ArrayData
    implements Data {
        private char[] array;

        private ArrayData() {
        }

        @Override
        public char charAt(int index) {
            return this.array[index];
        }

        @Override
        public void copyTo(int start, char[] cbuf, int off, int len) {
            System.arraycopy(this.array, start, cbuf, off, len);
        }

        static /* synthetic */ char[] access$102(ArrayData x0, char[] x1) {
            x0.array = x1;
            return x1;
        }
    }

    private static interface Data {
        public char charAt(int var1);

        public void copyTo(int var1, char[] var2, int var3, int var4);
    }
}

