/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.obfuscation.spring;

import com.github.robtimus.obfuscation.Obfuscated;
import com.github.robtimus.obfuscation.Obfuscator;
import com.github.robtimus.obfuscation.spring.ObfuscatorSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;

public class ObfuscatedSupportBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        DefaultListableBeanFactory listableBeanFactory = (DefaultListableBeanFactory)beanFactory;
        listableBeanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new ObfuscatedAutowireCandidateResolver(listableBeanFactory));
        listableBeanFactory.setTypeConverter((TypeConverter)new ObfuscatedTypeConverter(listableBeanFactory));
    }

    private static final class ObfuscatedTypeConverter
    extends ObfuscatorSupport
    implements TypeConverter {
        private final TypeConverter delegate;

        private ObfuscatedTypeConverter(DefaultListableBeanFactory beanFactory) {
            super(beanFactory);
            this.delegate = beanFactory.getTypeConverter();
        }

        public <T> T convertIfNecessary(Object value, Class<T> requiredType) {
            return (T)this.delegate.convertIfNecessary(value, requiredType);
        }

        public <T> T convertIfNecessary(Object value, Class<T> requiredType, Field field) {
            if (this.needsConversion(value, requiredType)) {
                Annotation[] annotations = field.getAnnotations();
                Obfuscator obfuscator = this.obfuscator(annotations);
                ResolvableType genericResolvableType = this.getGenericType(field);
                Class genericRequiredType = genericResolvableType.getRawClass();
                Object unobfuscatedValue = this.beanFactory().getTypeConverter().convertIfNecessary(value, genericRequiredType, field);
                return this.obfuscateValue(unobfuscatedValue, obfuscator, annotations, genericRequiredType);
            }
            return (T)this.delegate.convertIfNecessary(value, requiredType, field);
        }

        public <T> T convertIfNecessary(Object value, Class<T> requiredType, MethodParameter methodParam) {
            if (this.needsConversion(value, requiredType)) {
                Annotation[] annotations = methodParam.getParameterAnnotations();
                Obfuscator obfuscator = this.obfuscator(annotations);
                ResolvableType genericResolvableType = this.getGenericType(methodParam);
                Class genericRequiredType = genericResolvableType.getRawClass();
                Object unobfuscatedValue = this.beanFactory().getTypeConverter().convertIfNecessary(value, genericRequiredType, methodParam);
                return this.obfuscateValue(unobfuscatedValue, obfuscator, annotations, genericRequiredType);
            }
            return (T)this.delegate.convertIfNecessary(value, requiredType, methodParam);
        }

        public <T> T convertIfNecessary(Object value, Class<T> requiredType, TypeDescriptor typeDescriptor) {
            if (this.needsConversion(value, requiredType)) {
                return (T)super.convertIfNecessary(value, requiredType, typeDescriptor);
            }
            return (T)this.delegate.convertIfNecessary(value, requiredType, typeDescriptor);
        }

        private boolean needsConversion(Object value, Class<?> requiredType) {
            return Obfuscated.class.isAssignableFrom(requiredType) && !(value instanceof Obfuscated);
        }

        private ResolvableType getGenericType(Field field) {
            TypeDescriptor typeDescriptor = new TypeDescriptor(field);
            return typeDescriptor.getResolvableType().getGeneric(new int[]{0});
        }

        private ResolvableType getGenericType(MethodParameter methodParameter) {
            TypeDescriptor typeDescriptor = new TypeDescriptor(methodParameter);
            return typeDescriptor.getResolvableType().getGeneric(new int[]{0});
        }
    }

    private static final class ObfuscatedAutowireCandidateResolver
    extends ObfuscatorSupport
    implements AutowireCandidateResolver {
        private final AutowireCandidateResolver delegate;

        private ObfuscatedAutowireCandidateResolver(DefaultListableBeanFactory beanFactory) {
            this(beanFactory.getAutowireCandidateResolver(), beanFactory);
        }

        private ObfuscatedAutowireCandidateResolver(AutowireCandidateResolver delegate, DefaultListableBeanFactory beanFactory) {
            super(beanFactory);
            this.delegate = delegate;
        }

        public boolean isAutowireCandidate(BeanDefinitionHolder bdHolder, DependencyDescriptor descriptor) {
            return this.delegate.isAutowireCandidate(bdHolder, descriptor);
        }

        public boolean isRequired(DependencyDescriptor descriptor) {
            return this.delegate.isRequired(descriptor);
        }

        public boolean hasQualifier(DependencyDescriptor descriptor) {
            return this.delegate.hasQualifier(descriptor);
        }

        public Object getSuggestedValue(DependencyDescriptor descriptor) {
            if (Obfuscated.class.isAssignableFrom(descriptor.getDependencyType())) {
                DependencyDescriptor genericDescriptor = this.genericType(descriptor);
                Object result = this.beanFactory().getAutowireCandidateResolver().getSuggestedValue(genericDescriptor);
                if (result == null) {
                    result = this.beanFactory().getBeanProvider(genericDescriptor.getDependencyType()).getIfAvailable();
                }
                return result;
            }
            return this.delegate.getSuggestedValue(descriptor);
        }

        public Object getLazyResolutionProxyIfNecessary(DependencyDescriptor descriptor, String beanName) {
            if (Obfuscated.class.isAssignableFrom(descriptor.getDependencyType())) {
                DependencyDescriptor genericDescriptor = this.genericType(descriptor);
                Object result = this.beanFactory().getAutowireCandidateResolver().getLazyResolutionProxyIfNecessary(genericDescriptor, beanName);
                if (result != null) {
                    Annotation[] annotations = descriptor.getAnnotations();
                    Obfuscator obfuscator = this.obfuscator(annotations);
                    result = this.obfuscateValue(result, obfuscator, annotations, genericDescriptor.getResolvableType().getRawClass());
                }
                return result;
            }
            return this.delegate.getLazyResolutionProxyIfNecessary(descriptor, beanName);
        }

        public AutowireCandidateResolver cloneIfNecessary() {
            AutowireCandidateResolver clonedDelegate = this.delegate.cloneIfNecessary();
            return clonedDelegate == this.delegate ? this : new ObfuscatedAutowireCandidateResolver(clonedDelegate, this.beanFactory());
        }

        private DependencyDescriptor genericType(DependencyDescriptor descriptor) {
            DependencyDescriptor genericDescriptor = new DependencyDescriptor(descriptor);
            genericDescriptor.increaseNestingLevel();
            return genericDescriptor;
        }
    }
}

